/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.io;

import java.util.List;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.flink.streaming.api.functions.source.RichSourceFunction;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class TestStreamSource<@UnknownKeyFor T>
extends RichSourceFunction<WindowedValue<T>> {
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized TestStream<T>> testStreamDecoder;
    private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] payload;
    private volatile @UnknownKeyFor @NonNull @Initialized boolean isRunning = true;

    public TestStreamSource(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized TestStream<T>> testStreamDecoder, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] payload) {
        this.testStreamDecoder = testStreamDecoder;
        this.payload = payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized SourceFunction.SourceContext<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> ctx) throws @UnknownKeyFor @NonNull @Initialized CoderException {
        TestStream testStream = (TestStream)this.testStreamDecoder.apply((Object)this.payload);
        List events = testStream.getEvents();
        for (int eventId = 0; this.isRunning && eventId < events.size(); ++eventId) {
            TestStream.Event event = (TestStream.Event)events.get(eventId);
            Object object = ctx.getCheckpointLock();
            synchronized (object) {
                if (event instanceof TestStream.ElementEvent) {
                    for (TimestampedValue element : ((TestStream.ElementEvent)event).getElements()) {
                        Instant timestamp = element.getTimestamp();
                        WindowedValue value = WindowedValue.of((Object)element.getValue(), (Instant)timestamp, (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING);
                        ctx.collectWithTimestamp((Object)value, timestamp.getMillis());
                    }
                } else if (event instanceof TestStream.WatermarkEvent) {
                    long millis = ((TestStream.WatermarkEvent)event).getWatermark().getMillis();
                    ctx.emitWatermark(new Watermark(millis));
                } else {
                    if (event instanceof TestStream.ProcessingTimeEvent) {
                        throw new UnsupportedOperationException("Advancing Processing time is not supported by the Flink Runner.");
                    }
                    throw new IllegalStateException("Unknown event type " + event);
                }
                continue;
            }
        }
    }

    public void cancel() {
        this.isRunning = false;
    }
}

