/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.codegen;

import com.sforce.ws.bind.NameMapper;
import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.codegen.Compiler;
import com.sforce.ws.codegen.TypeMetadataConstructor;
import com.sforce.ws.codegen.metadata.ClassMetadata;
import com.sforce.ws.codegen.metadata.ComplexClassMetadata;
import com.sforce.ws.codegen.metadata.SimpleClassMetadata;
import com.sforce.ws.tools.ToolsException;
import com.sforce.ws.util.FileUtil;
import com.sforce.ws.util.Verbose;
import com.sforce.ws.wsdl.ComplexType;
import com.sforce.ws.wsdl.Definitions;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.SfdcApiType;
import com.sforce.ws.wsdl.SimpleType;
import com.sforce.ws.wsdl.Types;
import com.sforce.ws.wsdl.WsdlFactory;
import com.sforce.ws.wsdl.WsdlParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupDir;

public abstract class Generator {
    private static final int BUFFER_SIZE_16_KIB = 16384;
    private static final String AGGREGATE_RESULT_JAVA = "AggregateResult.java";
    private static final String EXTENDED_ERROR_DETAILS_JAVA = "ExtendedErrorDetails.java";
    private static final String IEXTENDED_ERROR_DETAILS_JAVA = "IExtendedErrorDetails.java";
    private static final String SOBJECT_JAVA = "SObject.java";
    private static final String ISOBJECT_JAVA = "ISObject.java";
    public static final String AGGREGATE_RESULT = "aggregateResult";
    public static final String SIMPLE_TYPE = "simpleType";
    public static final String SIMPLE_TYPE_ORGANIZATION_VALUE = "simpleTypeOrganizationValue";
    public static final String SOBJECT = "sobject";
    public static final String ISOBJECT = "isobject";
    public static final String EXTENDED_ERROR_DETAILS = "extendedErrorDetails";
    public static final String IEXTENDED_ERROR_DETAILS = "iExtendedErrorDetails";
    public static final String TYPE = "type";
    public static final String TYPE_INTERFACE = "typeinterface";
    protected final TypeMapper typeMapper;
    protected final ArrayList<File> javaFiles = new ArrayList();
    protected final String packagePrefix;
    protected final STGroupDir templates;
    protected boolean generateInterfaces;

    public Generator(String packagePrefix, STGroupDir templates, String interfacePackagePrefix, char startDelim, char endDelim) {
        this(packagePrefix, templates, interfacePackagePrefix);
    }

    public Generator(String packagePrefix, STGroupDir templates, String interfacePackagePrefix) {
        this(packagePrefix, templates, interfacePackagePrefix, false);
    }

    public Generator(String packagePrefix, STGroupDir templates, String interfacePackagePrefix, boolean javaTime) {
        this.templates = templates;
        this.packagePrefix = packagePrefix;
        this.typeMapper = new TypeMapper(packagePrefix, interfacePackagePrefix, javaTime);
    }

    public void generate(URL wsdl, File dest) throws WsdlParseException, IOException {
        Definitions definitions = WsdlFactory.create(wsdl);
        SfdcApiType sfdcApiType = definitions.getApiType();
        this.generateInterfaces = sfdcApiType == SfdcApiType.Partner;
        this.typeMapper.setGenerateInterfaces(this.generateInterfaces);
        Types types = definitions.getTypes();
        this.generate(definitions, sfdcApiType, types, dest);
    }

    protected void addFileToJar(String className, String classFile, JarOutputStream jar) throws IOException {
        int cb;
        className = className.replace('\\', '/');
        FileInputStream fio = new FileInputStream(classFile);
        jar.putNextEntry(new JarEntry(className));
        byte[] buffer = new byte[8192];
        while ((cb = fio.read(buffer)) != -1) {
            jar.write(buffer, 0, cb);
        }
        jar.closeEntry();
        fio.close();
    }

    protected void addRuntimeClasses(JarOutputStream jar) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        ArrayList<String> runtimeClasses = this.getRuntimeClasses(cl);
        for (String c : runtimeClasses) {
            int ch;
            jar.putNextEntry(new JarEntry(c));
            InputStream in = cl.getResourceAsStream(c);
            while ((ch = in.read()) != -1) {
                jar.write((char)ch);
            }
            jar.closeEntry();
            in.close();
        }
    }

    protected void compileTypes() throws ToolsException {
        Compiler compiler = new Compiler();
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File f : this.javaFiles) {
            fileNames.add(f.getPath());
        }
        compiler.compile(fileNames.toArray(new String[fileNames.size()]));
    }

    protected void generate(Definitions definitions, SfdcApiType sfdcApiType, Types types, File dir) throws IOException {
        this.generateTypeClasses(types, dir);
        if (sfdcApiType != null && sfdcApiType.getSobjectNamespace() != null) {
            if (this.requiresSObjectClass(definitions)) {
                this.generateSObjectClass(definitions, dir);
            }
            if (this.requiresSObjectInterface(definitions)) {
                this.generateSObjectInterface(definitions, dir);
            }
            if (this.requiresAggregateResultClass(definitions)) {
                this.generateAggregateResultClasses(definitions, dir);
            }
        }
        if (sfdcApiType != null && this.typeMapper.getGenerateExtendedErrorCodes()) {
            this.generateExtendedErrorDetailsClasses(definitions, dir);
        }
    }

    protected File generate(String packageName, String fileName, Object gen, ST template, File dir) throws IOException {
        template.add("gen", gen);
        File source = new File(FileUtil.mkdirs(packageName, dir), fileName);
        PrintWriter out = null;
        out = new PrintWriter(new BufferedWriter(this.newSourceWriter(source), 16384));
        try {
            out.print(template.render());
        }
        finally {
            out.close();
        }
        return source;
    }

    protected Writer newSourceWriter(File source) throws IOException {
        return new FileWriter(source);
    }

    protected void generateAggregateResultClasses(Definitions definitions, File dir) throws IOException {
        this.generateAggregateResultClasses(this.getPackageName(definitions), dir);
    }

    protected void generateAggregateResultClasses(String packageName, File dir) throws IOException {
        ClassMetadata gen = new ClassMetadata(packageName, null);
        ST template = this.templates.getInstanceOf(AGGREGATE_RESULT);
        this.javaFiles.add(this.generate(packageName, AGGREGATE_RESULT_JAVA, gen, template, dir));
    }

    protected void generateExtendedErrorDetailsClasses(Definitions definitions, File dir) throws IOException {
        String packageName = NameMapper.getPackageName(definitions.getApiType().getNamespace(), this.packagePrefix);
        ComplexClassMetadata gen = new ComplexClassMetadata(packageName, null, null, null, null, null, null, null, this.typeMapper.generateInterfaces(), null, null);
        ST template = this.templates.getInstanceOf(EXTENDED_ERROR_DETAILS);
        this.javaFiles.add(this.generate(packageName, EXTENDED_ERROR_DETAILS_JAVA, gen, template, dir));
        if (this.generateInterfaces) {
            ST interfc = this.templates.getInstanceOf(IEXTENDED_ERROR_DETAILS);
            this.javaFiles.add(this.generate(packageName, IEXTENDED_ERROR_DETAILS_JAVA, gen, interfc, dir));
        }
    }

    protected void generateClassFromComplexType(Types types, Schema schema, ComplexType complexType, File dir) throws IOException {
        ComplexClassMetadata gen = this.newTypeMetadataConstructor(types, schema, complexType, dir).generateMetadata();
        ST template = this.templates.getInstanceOf(TYPE);
        this.javaFiles.add(this.generate(gen.getPackageName(), String.valueOf(gen.getClassName()) + ".java", gen, template, dir));
        if (this.generateInterfaces) {
            ST interfc = this.templates.getInstanceOf(TYPE_INTERFACE);
            this.javaFiles.add(this.generate(gen.getPackageName(), String.valueOf(gen.getInterfaceName()) + ".java", gen, interfc, dir));
        }
    }

    protected TypeMetadataConstructor newTypeMetadataConstructor(Types types, Schema schema, ComplexType complexType, File dir) {
        return new TypeMetadataConstructor(types, schema, complexType, dir, this.typeMapper);
    }

    protected void generateClassFromSimpleType(Schema schema, SimpleType simpleType, File dir) throws IOException {
        SimpleClassMetadata gen = new SimpleClassMetadata(schema, simpleType, this.typeMapper);
        ST template = gen.getClassName().equals("OrganizationValue") ? this.templates.getInstanceOf(SIMPLE_TYPE_ORGANIZATION_VALUE) : this.templates.getInstanceOf(SIMPLE_TYPE);
        this.javaFiles.add(this.generate(gen.getPackageName(), String.valueOf(gen.getClassName()) + ".java", gen, template, dir));
    }

    protected void generateComplexTypeClass(Types types, Schema schema, File dir) throws IOException {
        for (ComplexType complexType : schema.getComplexTypes()) {
            if (this.typeMapper.isWellKnownType(complexType.getSchema().getTargetNamespace(), complexType.getName())) continue;
            this.generateClassFromComplexType(types, schema, complexType, dir);
        }
    }

    protected void generateJarFile(File jarFile, boolean standAlone, File dir) throws IOException {
        Verbose.log("Generating jar file ... " + jarFile);
        FileOutputStream out = new FileOutputStream(jarFile);
        InputStream manifestIo = this.getManifest();
        Manifest manifest = new Manifest(manifestIo);
        JarOutputStream jar = new JarOutputStream((OutputStream)out, manifest);
        int rootLen = dir.getAbsolutePath().length();
        int len = "java".length();
        for (File javaFile : this.javaFiles) {
            String fileName = javaFile.getPath();
            String classFile = String.valueOf(fileName.substring(0, fileName.length() - len)) + "class";
            String className = classFile.substring(rootLen + 1);
            this.addFileToJar(className, classFile, jar);
            String javaName = fileName.substring(rootLen + 1);
            this.addFileToJar(javaName, fileName, jar);
        }
        if (standAlone) {
            Verbose.log("Adding runtime classes to the jar");
            this.addRuntimeClasses(jar);
        }
        jar.close();
        out.close();
        Verbose.log("Generated jar file " + jarFile);
    }

    protected void generateSimpleTypeClass(Schema schema, File dir) throws IOException {
        for (SimpleType simpleType : schema.getSimpleTypes()) {
            if (this.typeMapper.isWellKnownType(simpleType.getSchema().getTargetNamespace(), simpleType.getName())) continue;
            this.generateClassFromSimpleType(schema, simpleType, dir);
        }
    }

    protected void generateSObjectClass(Definitions definitions, File dir) throws IOException {
        String packageName = this.getPackageName(definitions);
        ClassMetadata gen = new ClassMetadata(packageName, null, this.getInterfacePackageName(packageName));
        ST template = this.templates.getInstanceOf(SOBJECT);
        this.javaFiles.add(this.generate(packageName, SOBJECT_JAVA, gen, template, dir));
    }

    protected String getInterfacePackageName(String packageName) {
        return packageName;
    }

    protected void generateSObjectInterface(Definitions definitions, File dir) throws IOException {
        String packageName = this.getPackageName(definitions);
        ClassMetadata gen = new ClassMetadata(packageName, null, this.getInterfacePackageName(packageName));
        ST template = this.templates.getInstanceOf(ISOBJECT);
        this.javaFiles.add(this.generate(packageName, ISOBJECT_JAVA, gen, template, dir));
    }

    protected void generateTypeClass(Types types, Schema schema, File dir) throws IOException {
        this.generateComplexTypeClass(types, schema, dir);
        this.generateSimpleTypeClass(schema, dir);
    }

    protected void generateTypeClasses(Types types, File dir) throws IOException {
        Verbose.log("Generating Java files from schema ...");
        for (Schema s : types.getSchemas()) {
            this.generateTypeClass(types, s, dir);
        }
        Verbose.log("Generated " + this.javaFiles.size() + " java files.");
    }

    protected InputStream getManifest() {
        String m = "Manifest-Version: 1.0\nCreated-By: 1.4.2_05-b04 (Sun Microsystems Inc.)\n";
        return new ByteArrayInputStream(m.getBytes());
    }

    protected String getPackageName(Definitions definitions) {
        if (definitions.getApiType() == SfdcApiType.Tooling && !this.hasSobjectNamespace(definitions)) {
            return NameMapper.getPackageName(definitions.getApiType().getNamespace(), this.packagePrefix);
        }
        return NameMapper.getPackageName(definitions.getApiType().getSobjectNamespace(), this.packagePrefix);
    }

    private boolean hasSobjectNamespace(Definitions definitions) {
        for (Schema schema : definitions.getTypes().getSchemas()) {
            if (!schema.getTargetNamespace().equals(definitions.getApiType().getSobjectNamespace())) continue;
            return true;
        }
        return false;
    }

    protected ArrayList<String> getRuntimeClasses(ClassLoader cl) throws IOException {
        String line;
        ArrayList<String> classes = new ArrayList<String>();
        InputStream in = cl.getResourceAsStream("com/sforce/ws/runtime-classes.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while ((line = reader.readLine()) != null) {
            classes.add(line);
        }
        reader.close();
        return classes;
    }

    protected boolean requiresAggregateResultClass(Definitions definitions) {
        return definitions.getApiType() == SfdcApiType.Enterprise || definitions.getApiType() == SfdcApiType.Tooling;
    }

    protected boolean requiresSObjectClass(Definitions definitions) {
        return definitions.getApiType() == SfdcApiType.Partner || definitions.getApiType() == SfdcApiType.CrossInstance || definitions.getApiType() == SfdcApiType.Internal || definitions.getApiType() == SfdcApiType.ClientSync || definitions.getApiType() == SfdcApiType.SyncApi;
    }

    protected boolean requiresSObjectInterface(Definitions definitions) {
        return this.requiresSObjectClass(definitions);
    }
}

