/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;

public class DbxPKCEManager {
    public static final String CODE_CHALLENGE_METHODS = "S256";
    public static final int CODE_VERIFIER_SIZE = 128;
    private static final SecureRandom RAND = new SecureRandom();
    private static final String CODE_VERIFIER_CHAR_SET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~";
    private String codeVerifier;
    private String codeChallenge;

    public DbxPKCEManager() {
        this.codeVerifier = this.generateCodeVerifier();
        this.codeChallenge = DbxPKCEManager.generateCodeChallenge(this.codeVerifier);
    }

    public DbxPKCEManager(String codeVerifier) {
        this.codeVerifier = codeVerifier;
        this.codeChallenge = DbxPKCEManager.generateCodeChallenge(this.codeVerifier);
    }

    String generateCodeVerifier() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 128; ++i) {
            sb.append(CODE_VERIFIER_CHAR_SET.charAt(RAND.nextInt(CODE_VERIFIER_CHAR_SET.length())));
        }
        return sb.toString();
    }

    static String generateCodeChallenge(String codeVerifier) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] signiture = digest.digest(codeVerifier.getBytes("US-ASCII"));
            return StringUtil.urlSafeBase64Encode(signiture).replaceAll("=+$", "");
        }
        catch (NoSuchAlgorithmException e) {
            throw LangUtil.mkAssert("Impossible", e);
        }
        catch (UnsupportedEncodingException e) {
            throw LangUtil.mkAssert("Impossible", e);
        }
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public DbxAuthFinish makeTokenRequest(DbxRequestConfig requestConfig, String oauth2Code, String appKey, String redirectUri, DbxHost host) throws DbxException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "authorization_code");
        params.put("code", oauth2Code);
        params.put("locale", requestConfig.getUserLocale());
        params.put("client_id", appKey);
        params.put("code_verifier", this.codeVerifier);
        if (redirectUri != null) {
            params.put("redirect_uri", redirectUri);
        }
        return DbxRequestUtil.doPostNoAuth(requestConfig, "OfficialDropboxJavaSDKv2", host.getApi(), "oauth2/token", DbxRequestUtil.toParamsArray(params), null, new DbxRequestUtil.ResponseHandler<DbxAuthFinish>(){

            @Override
            public DbxAuthFinish handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxAuthFinish.Reader, response);
            }
        });
    }
}

