/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.fileproperties;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.fileproperties.PropertyType;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class PropertyFieldTemplate {
    @Nonnull
    protected final String name;
    @Nonnull
    protected final String description;
    @Nonnull
    protected final PropertyType type;

    public PropertyFieldTemplate(@Nonnull String name, @Nonnull String description, @Nonnull PropertyType type) {
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        if (description == null) {
            throw new IllegalArgumentException("Required value for 'description' is null");
        }
        this.description = description;
        if (type == null) {
            throw new IllegalArgumentException("Required value for 'type' is null");
        }
        this.type = type;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public PropertyType getType() {
        return this.type;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.name, this.description, this.type});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            PropertyFieldTemplate other = (PropertyFieldTemplate)obj;
            return !(this.name != other.name && !this.name.equals(other.name) || this.description != other.description && !this.description.equals(other.description) || this.type != other.type && !this.type.equals((Object)other.type));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PropertyFieldTemplate> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PropertyFieldTemplate value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            g.writeFieldName("description");
            StoneSerializers.string().serialize(value.description, g);
            g.writeFieldName("type");
            PropertyType.Serializer.INSTANCE.serialize(value.type, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public PropertyFieldTemplate deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            PropertyType f_type;
            String f_description;
            String f_name;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_name = null;
                f_description = null;
                f_type = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("description".equals(field)) {
                        f_description = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("type".equals(field)) {
                        f_type = PropertyType.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_description == null) {
                    throw new JsonParseException(p, "Required field \"description\" missing.");
                }
                if (f_type == null) {
                    throw new JsonParseException(p, "Required field \"type\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PropertyFieldTemplate value = new PropertyFieldTemplate(f_name, f_description, f_type);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

