/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.ParentFolderAccessInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class MemberAccessLevelResult {
    @Nullable
    protected final AccessLevel accessLevel;
    @Nullable
    protected final String warning;
    @Nullable
    protected final List<ParentFolderAccessInfo> accessDetails;

    public MemberAccessLevelResult(@Nullable AccessLevel accessLevel, @Nullable String warning, @Nullable List<ParentFolderAccessInfo> accessDetails) {
        this.accessLevel = accessLevel;
        this.warning = warning;
        if (accessDetails != null) {
            for (ParentFolderAccessInfo x : accessDetails) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'accessDetails' is null");
            }
        }
        this.accessDetails = accessDetails;
    }

    public MemberAccessLevelResult() {
        this(null, null, null);
    }

    @Nullable
    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    @Nullable
    public String getWarning() {
        return this.warning;
    }

    @Nullable
    public List<ParentFolderAccessInfo> getAccessDetails() {
        return this.accessDetails;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.accessLevel, this.warning, this.accessDetails});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            MemberAccessLevelResult other = (MemberAccessLevelResult)obj;
            return (this.accessLevel == other.accessLevel || this.accessLevel != null && this.accessLevel.equals((Object)other.accessLevel)) && (this.warning == other.warning || this.warning != null && this.warning.equals(other.warning)) && (this.accessDetails == other.accessDetails || this.accessDetails != null && this.accessDetails.equals(other.accessDetails));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<MemberAccessLevelResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MemberAccessLevelResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.accessLevel != null) {
                g.writeFieldName("access_level");
                StoneSerializers.nullable(AccessLevel.Serializer.INSTANCE).serialize(value.accessLevel, g);
            }
            if (value.warning != null) {
                g.writeFieldName("warning");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.warning, g);
            }
            if (value.accessDetails != null) {
                g.writeFieldName("access_details");
                StoneSerializers.nullable(StoneSerializers.list(ParentFolderAccessInfo.Serializer.INSTANCE)).serialize(value.accessDetails, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public MemberAccessLevelResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<ParentFolderAccessInfo> f_accessDetails;
            String f_warning;
            AccessLevel f_accessLevel;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_accessLevel = null;
                f_warning = null;
                f_accessDetails = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("access_level".equals(field)) {
                        f_accessLevel = StoneSerializers.nullable(AccessLevel.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("warning".equals(field)) {
                        f_warning = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("access_details".equals(field)) {
                        f_accessDetails = StoneSerializers.nullable(StoneSerializers.list(ParentFolderAccessInfo.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            MemberAccessLevelResult value = new MemberAccessLevelResult(f_accessLevel, f_warning, f_accessDetails);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected AccessLevel accessLevel = null;
        protected String warning = null;
        protected List<ParentFolderAccessInfo> accessDetails = null;

        protected Builder() {
        }

        public Builder withAccessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder withWarning(String warning) {
            this.warning = warning;
            return this;
        }

        public Builder withAccessDetails(List<ParentFolderAccessInfo> accessDetails) {
            if (accessDetails != null) {
                for (ParentFolderAccessInfo x : accessDetails) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'accessDetails' is null");
                }
            }
            this.accessDetails = accessDetails;
            return this;
        }

        public MemberAccessLevelResult build() {
            return new MemberAccessLevelResult(this.accessLevel, this.warning, this.accessDetails);
        }
    }
}

