/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.expr;

import io.github.spannm.jackcess.expr.LocaleContext;
import java.math.BigDecimal;
import java.time.LocalDateTime;

public interface Value {
    public Type getType();

    public Object get();

    public boolean isNull();

    public boolean getAsBoolean(LocaleContext var1);

    public String getAsString(LocaleContext var1);

    public LocalDateTime getAsLocalDateTime(LocaleContext var1);

    public Value getAsDateTimeValue(LocaleContext var1);

    public Integer getAsLongInt(LocaleContext var1);

    public Double getAsDouble(LocaleContext var1);

    public BigDecimal getAsBigDecimal(LocaleContext var1);

    public static enum Type {
        NULL,
        STRING,
        DATE,
        TIME,
        DATE_TIME,
        LONG,
        DOUBLE,
        BIG_DEC;


        public boolean isString() {
            return this == STRING;
        }

        public boolean isNumeric() {
            return this.inRange(LONG, BIG_DEC);
        }

        public boolean isIntegral() {
            return this == LONG;
        }

        public boolean isTemporal() {
            return this.inRange(DATE, DATE_TIME);
        }

        public Type getPreferredFPType() {
            return this.ordinal() <= DOUBLE.ordinal() ? DOUBLE : BIG_DEC;
        }

        public Type getPreferredNumericType() {
            if (this.isNumeric()) {
                return this;
            }
            if (this.isTemporal()) {
                return this == DATE ? LONG : DOUBLE;
            }
            return null;
        }

        private boolean inRange(Type start, Type end) {
            return start.ordinal() <= this.ordinal() && this.ordinal() <= end.ordinal();
        }
    }
}

