/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.util;

import io.github.spannm.jackcess.impl.ColumnImpl;
import io.github.spannm.jackcess.impl.expr.Expressionator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class PatternColumnPredicate
implements Predicate<Object> {
    private static final int LIKE_REGEX_FLAGS = 32;
    private static final int CI_LIKE_REGEX_FLAGS = 98;
    private final Pattern _pattern;

    public PatternColumnPredicate(Pattern pattern) {
        this._pattern = pattern;
    }

    @Override
    public boolean test(Object value) {
        try {
            CharSequence cs = ColumnImpl.toCharSequence(value);
            return this._pattern.matcher(cs).matches();
        }
        catch (IOException _ex) {
            throw new UncheckedIOException("Could not coerece column value to string", _ex);
        }
    }

    private static Pattern sqlLikeToRegex(String value, boolean caseInsensitive) {
        StringBuilder sb = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '%') {
                sb.append(".*");
                continue;
            }
            if (c == '_') {
                sb.append('.');
                continue;
            }
            if (c == '\\') {
                if (i + 1 >= value.length()) continue;
                PatternColumnPredicate.appendLiteralChar(sb, value.charAt(++i));
                continue;
            }
            PatternColumnPredicate.appendLiteralChar(sb, c);
        }
        int flags = caseInsensitive ? 98 : 32;
        return Pattern.compile(sb.toString(), flags);
    }

    private static void appendLiteralChar(StringBuilder sb, char c) {
        if (Expressionator.isRegexSpecialChar(c)) {
            sb.append('\\');
        }
        sb.append(c);
    }

    public static PatternColumnPredicate forAccessLike(String pattern) {
        return new PatternColumnPredicate(Expressionator.likePatternToRegex(pattern));
    }

    public static PatternColumnPredicate forSqlLike(String pattern) {
        return PatternColumnPredicate.forSqlLike(pattern, false);
    }

    public static PatternColumnPredicate forSqlLike(String pattern, boolean caseInsensitive) {
        return new PatternColumnPredicate(PatternColumnPredicate.sqlLikeToRegex(pattern, caseInsensitive));
    }

    public static PatternColumnPredicate forJavaRegex(String pattern) {
        return new PatternColumnPredicate(Pattern.compile(pattern));
    }
}

