/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.selectvalues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.selectvalues.DeleteField;
import org.apache.hop.pipeline.transforms.selectvalues.SelectField;
import org.apache.hop.pipeline.transforms.selectvalues.SelectMetadataChange;
import org.apache.hop.pipeline.transforms.selectvalues.SelectOptions;
import org.apache.hop.pipeline.transforms.selectvalues.SelectValues;
import org.apache.hop.pipeline.transforms.selectvalues.SelectValuesData;

@Transform(id="SelectValues", image="selectvalues.svg", name="i18n:org.apache.hop.pipeline.transforms.selectvalues:SelectValues.Name", description="i18n:org.apache.hop.pipeline.transforms.selectvalues:SelectValues.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::SelectValuesMeta.keyword"}, documentationUrl="/pipeline/transforms/selectvalues.html")
public class SelectValuesMeta
extends BaseTransformMeta<SelectValues, SelectValuesData> {
    private static final Class<?> PKG = SelectValuesMeta.class;
    public static final int UNDEFINED = -2;
    @HopMetadataProperty(key="fields")
    private SelectOptions selectOption = new SelectOptions();

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            IRowMeta rowMeta = inputRowMeta.clone();
            inputRowMeta.clear();
            inputRowMeta.addRowMeta(rowMeta);
            this.getSelectFields(inputRowMeta, name);
            this.getDeleteFields(inputRowMeta);
            this.getMetadataFields(inputRowMeta, name, variables);
        }
        catch (Exception e) {
            throw new HopTransformException((Throwable)e);
        }
    }

    public String[] getSelectName() {
        String[] selectName = new String[this.getSelectOption().getSelectFields().size()];
        for (int i = 0; i < selectName.length; ++i) {
            selectName[i] = this.getSelectOption().getSelectFields().get(i).getName();
        }
        return selectName;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            int idx;
            int i;
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.TransformReceivingFields", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (i = 0; i < this.getSelectOption().getSelectFields().size(); ++i) {
                SelectField selectField = this.getSelectOption().getSelectFields().get(i);
                idx = prev.indexOfValue(selectField.getName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + selectField.getName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.SelectedFieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + (String)errorMessage;
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllSelectedFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            if (this.getSelectOption().getSelectFields().size() > 0) {
                for (i = 0; i < prev.size(); ++i) {
                    IValueMeta pv = prev.getValueMeta(i);
                    idx = Const.indexOfString((String)pv.getName(), (String[])this.getSelectName());
                    if (idx >= 0) continue;
                    errorMessage = (String)errorMessage + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                    errorFound = true;
                }
                if (errorFound) {
                    errorMessage = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.FieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + (String)errorMessage;
                    cr = new CheckResult(2, (String)errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllSelectedFieldsFound2", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            }
            errorMessage = "";
            errorFound = false;
            for (i = 0; i < this.getSelectOption().getDeleteName().size(); ++i) {
                int idx2 = prev.indexOfValue(this.getSelectOption().getDeleteName().get(i).getName());
                if (idx2 >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + String.valueOf(this.getSelectOption().getDeleteName().get(i)) + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.DeSelectedFieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + (String)errorMessage;
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllDeSelectedFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            errorMessage = "";
            errorFound = false;
            for (i = 0; i < this.getSelectOption().getMeta().size(); ++i) {
                String currentName = this.getSelectOption().getMeta().get(i).getName();
                idx = prev.indexOfValue(currentName);
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + currentName + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.MetadataFieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + (String)errorMessage;
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.AllMetadataFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.FieldsNotFound2", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        int selectFieldsSize = this.getSelectOption().getSelectFields().size();
        int[] cnt = new int[selectFieldsSize];
        boolean errorFound = false;
        Object errorMessage = "";
        for (int i = 0; i < selectFieldsSize; ++i) {
            cnt[i] = 0;
            for (int j = 0; j < selectFieldsSize; ++j) {
                if (!this.getSelectOption().getSelectFields().get(i).getName().equals(this.getSelectOption().getSelectFields().get(j).getName())) continue;
                int n = i;
                cnt[n] = cnt[n] + 1;
            }
            if (cnt[i] <= 1) continue;
            if (!errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.DuplicateFieldsSpecified", (String[])new String[0]) + Const.CR;
            } else {
                errorFound = true;
            }
            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"SelectValuesMeta.CheckResult.OccurentRow", (String[])new String[]{i + " : " + this.getSelectOption().getSelectFields().get(i).getName() + "  (" + cnt[i]}) + Const.CR;
            errorFound = true;
        }
        if (errorFound) {
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public SelectOptions getSelectOption() {
        return this.selectOption;
    }

    public void setSelectOption(SelectOptions selectOption) {
        this.selectOption = selectOption;
    }

    public void getSelectFields(IRowMeta inputRowMeta, String name) throws HopTransformException {
        List<SelectField> selectFields = this.selectOption.getSelectFields();
        if (selectFields != null && !selectFields.isEmpty()) {
            RowMeta row = new RowMeta();
            for (int i = 0; i < selectFields.size(); ++i) {
                IValueMeta v = inputRowMeta.searchValueMeta(selectFields.get(i).getName());
                SelectField selectField = selectFields.get(i);
                if (v == null) continue;
                if (!(v = v.clone()).getName().equals(selectField.getRename()) && selectField.getRename() != null && selectField.getRename().length() > 0) {
                    v.setName(selectField.getRename());
                    v.setOrigin(name);
                }
                if (selectField.getLength() != -2) {
                    v.setLength(selectField.getLength());
                    v.setOrigin(name);
                }
                if (selectField.getPrecision() != -2) {
                    v.setPrecision(selectField.getPrecision());
                    v.setOrigin(name);
                }
                row.addValueMeta(v);
            }
            if (this.getSelectOption().isSelectingAndSortingUnspecifiedFields()) {
                ArrayList<String> extra = new ArrayList<String>();
                for (int i = 0; i < inputRowMeta.size(); ++i) {
                    String fieldName = inputRowMeta.getValueMeta(i).getName();
                    if (Const.indexOfString((String)fieldName, (String[])this.getSelectName()) >= 0) continue;
                    extra.add(fieldName);
                }
                Collections.sort(extra);
                for (String fieldName : extra) {
                    IValueMeta extraValue = inputRowMeta.searchValueMeta(fieldName);
                    row.addValueMeta(extraValue);
                }
            }
            inputRowMeta.clear();
            inputRowMeta.addRowMeta((IRowMeta)row);
        }
    }

    public void getDeleteFields(IRowMeta inputRowMeta) throws HopTransformException {
        List<DeleteField> deleteNames = this.getSelectOption().getDeleteName();
        if (deleteNames != null && !deleteNames.isEmpty()) {
            for (DeleteField deleteName : deleteNames) {
                try {
                    inputRowMeta.removeValueMeta(deleteName.getName());
                }
                catch (HopValueException e) {
                    throw new HopTransformException((Throwable)e);
                }
            }
        }
    }

    public void getMetadataFields(IRowMeta inputRowMeta, String name, IVariables variables) throws HopPluginException {
        List<SelectMetadataChange> meta = this.getSelectOption().getMeta();
        if (meta != null && !meta.isEmpty()) {
            for (int i = 0; i < meta.size(); ++i) {
                SelectMetadataChange metaChange = meta.get(i);
                int idx = inputRowMeta.indexOfValue(metaChange.getName());
                if (idx < 0) continue;
                IValueMeta v = inputRowMeta.getValueMeta(idx);
                if (!v.getName().equals(metaChange.getRename()) && !Utils.isEmpty((CharSequence)metaChange.getRename())) {
                    v.setName(metaChange.getRename());
                    v.setOrigin(name);
                }
                if (!metaChange.getType().equals(ValueMetaFactory.getValueMetaName((int)0)) && !ValueMetaFactory.getValueMetaName((int)v.getType()).equals(metaChange.getType())) {
                    v = ValueMetaFactory.cloneValueMeta((IValueMeta)v, (int)ValueMetaFactory.getIdForValueMeta((String)metaChange.getType()));
                    inputRowMeta.setValueMeta(idx, v);
                    v.setStorageType(0);
                }
                if (metaChange.getLength() != -2) {
                    v.setLength(metaChange.getLength());
                    v.setOrigin(name);
                }
                if (metaChange.getPrecision() != -2) {
                    v.setPrecision(metaChange.getPrecision());
                    v.setOrigin(name);
                }
                if (metaChange.getStorageType() != null) {
                    v.setStorageType(ValueMetaFactory.getIdForValueMeta((String)metaChange.getStorageType()));
                    v.setOrigin(name);
                }
                if (!Utils.isEmpty((CharSequence)metaChange.getConversionMask())) {
                    v.setConversionMask(metaChange.getConversionMask());
                    v.setOrigin(name);
                }
                v.setDateFormatLenient(metaChange.isDateFormatLenient());
                v.setDateFormatLocale(EnvUtil.createLocale((String)metaChange.getDateFormatLocale()));
                v.setDateFormatTimeZone(EnvUtil.createTimeZone((String)metaChange.getDateFormatTimeZone()));
                v.setLenientStringToNumber(metaChange.isLenientStringToNumber());
                if (!Utils.isEmpty((CharSequence)metaChange.getEncoding())) {
                    v.setStringEncoding(metaChange.getEncoding());
                    v.setOrigin(name);
                }
                if (!Utils.isEmpty((CharSequence)metaChange.getDecimalSymbol())) {
                    v.setDecimalSymbol(metaChange.getDecimalSymbol());
                    v.setOrigin(name);
                }
                if (!Utils.isEmpty((CharSequence)metaChange.getGroupingSymbol())) {
                    v.setGroupingSymbol(metaChange.getGroupingSymbol());
                    v.setOrigin(name);
                }
                if (Utils.isEmpty((CharSequence)metaChange.getCurrencySymbol())) continue;
                v.setCurrencySymbol(metaChange.getCurrencySymbol());
                v.setOrigin(name);
            }
        }
    }
}

