/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import org.apache.beam.runners.core.MergingStateAccessor;
import org.apache.beam.runners.core.StateAccessor;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.runners.core.triggers.DefaultTriggerStateMachine;
import org.apache.beam.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.runners.core.triggers.FinishedTriggers;
import org.apache.beam.runners.core.triggers.FinishedTriggersBitSet;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachineContextFactory;
import org.apache.beam.sdk.coders.BitSetCoder;
import org.apache.beam.sdk.state.Timers;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class TriggerStateMachineRunner<@UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> {
    @VisibleForTesting
    public static final @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized BitSet>> FINISHED_BITS_TAG = StateTags.makeSystemTagInternal(StateTags.value("closed", BitSetCoder.of()));
    private final @UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine rootTrigger;
    private final @UnknownKeyFor @NonNull @Initialized TriggerStateMachineContextFactory<W> contextFactory;

    public TriggerStateMachineRunner(@UnknownKeyFor @NonNull @Initialized ExecutableTriggerStateMachine rootTrigger, @UnknownKeyFor @NonNull @Initialized TriggerStateMachineContextFactory<W> contextFactory) {
        Preconditions.checkState((rootTrigger.getTriggerIndex() == 0 ? 1 : 0) != 0);
        this.rootTrigger = rootTrigger;
        this.contextFactory = contextFactory;
    }

    private @UnknownKeyFor @NonNull @Initialized FinishedTriggersBitSet readFinishedBits(@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized BitSet> state) {
        if (!this.isFinishedSetNeeded()) {
            return FinishedTriggersBitSet.emptyWithCapacity(this.rootTrigger.getFirstIndexAfterSubtree());
        }
        @Nullable BitSet bitSet = (BitSet)state.read();
        return bitSet == null ? FinishedTriggersBitSet.emptyWithCapacity(this.rootTrigger.getFirstIndexAfterSubtree()) : FinishedTriggersBitSet.fromBitSet(bitSet);
    }

    private void clearFinishedBits(@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized BitSet> state) {
        if (!this.isFinishedSetNeeded()) {
            return;
        }
        state.clear();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isClosed(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> state) {
        return this.readFinishedBits(state.access(FINISHED_BITS_TAG)).isFinished(this.rootTrigger);
    }

    public void prefetchIsClosed(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> state) {
        if (this.isFinishedSetNeeded()) {
            state.access(FINISHED_BITS_TAG).readLater();
        }
    }

    public void prefetchForValue(W window, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> state) {
        this.prefetchIsClosed(state);
        this.rootTrigger.invokePrefetchOnElement(this.contextFactory.createPrefetchContext(window, this.rootTrigger));
    }

    public void prefetchShouldFire(W window, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> state) {
        this.prefetchIsClosed(state);
        this.rootTrigger.invokePrefetchShouldFire(this.contextFactory.createPrefetchContext(window, this.rootTrigger));
    }

    public void processValue(W window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Timers timers, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> state) throws @UnknownKeyFor @NonNull @Initialized Exception {
        FinishedTriggersBitSet finishedSet = this.readFinishedBits(state.access(FINISHED_BITS_TAG)).copy();
        TriggerStateMachine.OnElementContext triggerContext = this.contextFactory.createOnElementContext(window, timers, timestamp, this.rootTrigger, finishedSet);
        this.rootTrigger.invokeOnElement(triggerContext);
        this.persistFinishedSet(state, finishedSet);
    }

    public void prefetchForMerge(W window, @UnknownKeyFor @NonNull @Initialized Collection<W> mergingWindows, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized MergingStateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> state) {
        if (this.isFinishedSetNeeded()) {
            for (ValueState<BitSet> value : state.accessInEachMergingWindow(FINISHED_BITS_TAG).values()) {
                value.readLater();
            }
        }
        this.rootTrigger.invokePrefetchOnMerge(this.contextFactory.createMergingPrefetchContext(window, mergingWindows, this.rootTrigger));
    }

    public void onMerge(W window, @UnknownKeyFor @NonNull @Initialized Timers timers, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized MergingStateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> state) throws @UnknownKeyFor @NonNull @Initialized Exception {
        FinishedTriggersBitSet finishedSet = this.readFinishedBits(state.access(FINISHED_BITS_TAG)).copy();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<W, ValueState<BitSet>> entry : state.accessInEachMergingWindow(FINISHED_BITS_TAG).entrySet()) {
            builder.put((Object)((BoundedWindow)entry.getKey()), (Object)this.readFinishedBits(entry.getValue()));
            this.clearFinishedBits(entry.getValue());
        }
        ImmutableMap mergingFinishedSets = builder.build();
        TriggerStateMachine.OnMergeContext mergeContext = this.contextFactory.createOnMergeContext(window, timers, this.rootTrigger, finishedSet, (Map<W, FinishedTriggers>)mergingFinishedSets);
        this.rootTrigger.invokeOnMerge(mergeContext);
        this.persistFinishedSet(state, finishedSet);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean shouldFire(W window, @UnknownKeyFor @NonNull @Initialized Timers timers, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> state) throws @UnknownKeyFor @NonNull @Initialized Exception {
        FinishedTriggersBitSet finishedSet = this.readFinishedBits(state.access(FINISHED_BITS_TAG)).copy();
        TriggerStateMachine.TriggerContext context = this.contextFactory.base(window, timers, this.rootTrigger, finishedSet);
        return this.rootTrigger.invokeShouldFire(context);
    }

    public void onFire(W window, @UnknownKeyFor @NonNull @Initialized Timers timers, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> state) throws @UnknownKeyFor @NonNull @Initialized Exception {
        FinishedTriggersBitSet finishedSet = this.readFinishedBits(state.access(FINISHED_BITS_TAG)).copy();
        TriggerStateMachine.TriggerContext context = this.contextFactory.base(window, timers, this.rootTrigger, finishedSet);
        this.rootTrigger.invokeOnFire(context);
        this.persistFinishedSet(state, finishedSet);
    }

    private void persistFinishedSet(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> state, @UnknownKeyFor @NonNull @Initialized FinishedTriggersBitSet modifiedFinishedSet) {
        if (!this.isFinishedSetNeeded()) {
            return;
        }
        ValueState<BitSet> finishedSetState = state.access(FINISHED_BITS_TAG);
        if (!this.readFinishedBits(finishedSetState).equals(modifiedFinishedSet)) {
            if (modifiedFinishedSet.getBitSet().isEmpty()) {
                finishedSetState.clear();
            } else {
                finishedSetState.write((Object)modifiedFinishedSet.getBitSet());
            }
        }
    }

    public void clearFinished(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> state) {
        this.clearFinishedBits(state.access(FINISHED_BITS_TAG));
    }

    public void clearState(W window, @UnknownKeyFor @NonNull @Initialized Timers timers, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> state) throws @UnknownKeyFor @NonNull @Initialized Exception {
        FinishedTriggersBitSet finishedSet = this.readFinishedBits(state.access(FINISHED_BITS_TAG));
        this.rootTrigger.invokeClear(this.contextFactory.base(window, timers, this.rootTrigger, finishedSet));
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isFinishedSetNeeded() {
        return !(this.rootTrigger.getSpec() instanceof DefaultTriggerStateMachine);
    }
}

