/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.server.common.HttpGetFailedException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageErrorReporter;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public final class Util {
    private static final Log LOG = LogFactory.getLog((String)Util.class.getName());
    public static final String FILE_LENGTH = "File-Length";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String MD5_HEADER = "X-MD5-Digest";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final int IO_FILE_BUFFER_SIZE;
    private static final boolean isSpnegoEnabled;
    public static final URLConnectionFactory connectionFactory;

    static URI stringAsURI(String s) throws IOException {
        URI u = null;
        try {
            u = new URI(s);
        }
        catch (URISyntaxException e) {
            LOG.error((Object)("Syntax error in URI " + s + ". Please check hdfs configuration."), (Throwable)e);
        }
        if (u == null || u.getScheme() == null) {
            LOG.warn((Object)("Path " + s + " should be specified as a URI in configuration files. Please update hdfs configuration."));
            u = Util.fileAsURI(new File(s));
        }
        return u;
    }

    public static URI fileAsURI(File f) throws IOException {
        URI u = f.getCanonicalFile().toURI();
        if (u.getPath().endsWith("/")) {
            String uriAsString = u.toString();
            try {
                u = new URI(uriAsString.substring(0, uriAsString.length() - 1));
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return u;
    }

    public static List<URI> stringCollectionAsURIs(Collection<String> names) {
        ArrayList<URI> uris = new ArrayList<URI>(names.size());
        for (String name : names) {
            try {
                uris.add(Util.stringAsURI(name));
            }
            catch (IOException e) {
                LOG.error((Object)("Error while processing URI: " + name), (Throwable)e);
            }
        }
        return uris;
    }

    public static MD5Hash doGetUrl(URL url, List<File> localPaths, Storage dstStorage, boolean getChecksum, int timeout, DataTransferThrottler throttler) throws IOException {
        HttpURLConnection connection;
        try {
            connection = (HttpURLConnection)connectionFactory.openConnection(url, isSpnegoEnabled);
        }
        catch (AuthenticationException e) {
            throw new IOException(e);
        }
        Util.setTimeout(connection, timeout);
        if (connection.getResponseCode() != 200) {
            throw new HttpGetFailedException("Image transfer servlet at " + url + " failed with status code " + connection.getResponseCode() + "\nResponse message:\n" + connection.getResponseMessage(), connection);
        }
        String contentLength = connection.getHeaderField(CONTENT_LENGTH);
        if (contentLength == null) {
            throw new IOException("Content-Length header is not provided by the namenode when trying to fetch " + url);
        }
        long advertisedSize = Long.parseLong(contentLength);
        MD5Hash advertisedDigest = Util.parseMD5Header(connection);
        String fsImageName = connection.getHeaderField("X-Image-Edits-Name");
        InputStream stream = connection.getInputStream();
        return Util.receiveFile(url.toExternalForm(), localPaths, dstStorage, getChecksum, advertisedSize, advertisedDigest, fsImageName, stream, throttler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MD5Hash receiveFile(String url, List<File> localPaths, Storage dstStorage, boolean getChecksum, long advertisedSize, MD5Hash advertisedDigest, String fsImageName, InputStream stream, DataTransferThrottler throttler) throws IOException {
        Object buf;
        long startTime = Time.monotonicNow();
        HashMap<FileOutputStream, File> streamPathMap = new HashMap<FileOutputStream, File>();
        StringBuilder xferStats = new StringBuilder();
        double xferCombined = 0.0;
        if (localPaths != null) {
            ArrayList<File> newLocalPaths = new ArrayList<File>();
            for (File localPath : localPaths) {
                if (localPath.isDirectory()) {
                    if (fsImageName == null) {
                        throw new IOException("No filename header provided by server");
                    }
                    newLocalPaths.add(new File(localPath, fsImageName));
                    continue;
                }
                newLocalPaths.add(localPath);
            }
            localPaths = newLocalPaths;
        }
        long received = 0L;
        MessageDigest digester = null;
        if (getChecksum) {
            digester = MD5Hash.getDigester();
            stream = new DigestInputStream(stream, digester);
        }
        boolean finishedReceiving = false;
        int num = 1;
        ArrayList outputStreams = Lists.newArrayList();
        try {
            if (localPaths != null) {
                for (File file : localPaths) {
                    try {
                        if (file.exists()) {
                            LOG.warn((Object)("Overwriting existing file " + file + " with file downloaded from " + url));
                        }
                        FileOutputStream fos = new FileOutputStream(file);
                        outputStreams.add(fos);
                        streamPathMap.put(fos, file);
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("Unable to download file " + file), (Throwable)ioe);
                        if (dstStorage == null || !(dstStorage instanceof StorageErrorReporter)) continue;
                        ((StorageErrorReporter)((Object)dstStorage)).reportErrorOnFile(file);
                    }
                }
                if (outputStreams.isEmpty()) {
                    throw new IOException("Unable to download to any storage directory");
                }
            }
            buf = new byte[IO_FILE_BUFFER_SIZE];
            while (num > 0) {
                num = stream.read((byte[])buf);
                if (num <= 0) continue;
                received += (long)num;
                for (FileOutputStream fos : outputStreams) {
                    fos.write((byte[])buf, 0, num);
                }
                if (throttler == null) continue;
                throttler.throttle(num);
            }
            finishedReceiving = true;
            double d = Math.max((double)(Time.monotonicNow() - startTime) / 1000.0, 0.001);
            long xferKb = received / 1024L;
            xferCombined += d;
            xferStats.append(String.format(" The file download took %.2fs at %.2f KB/s.", d, (double)xferKb / d));
        }
        catch (Throwable throwable) {
            stream.close();
            for (FileOutputStream fos : outputStreams) {
                long flushStartTime = Time.monotonicNow();
                fos.getChannel().force(true);
                fos.close();
                double writeSec = Math.max((double)(flushStartTime - Time.monotonicNow()) / 1000.0, 0.001);
                xferCombined += writeSec;
                xferStats.append(String.format(" Synchronous (fsync) write to disk of " + ((File)streamPathMap.get(fos)).getAbsolutePath() + " took %.2fs.", writeSec));
            }
            if (!finishedReceiving) {
                Util.deleteTmpFiles(localPaths);
            }
            if (finishedReceiving && received != advertisedSize) {
                Util.deleteTmpFiles(localPaths);
                throw new IOException("File " + url + " received length " + received + " is not of the advertised size " + advertisedSize + ". Fsimage name: " + fsImageName + " lastReceived: " + num);
            }
            throw throwable;
        }
        stream.close();
        buf = outputStreams.iterator();
        while (buf.hasNext()) {
            FileOutputStream fileOutputStream = (FileOutputStream)buf.next();
            long flushStartTime = Time.monotonicNow();
            fileOutputStream.getChannel().force(true);
            fileOutputStream.close();
            double writeSec = Math.max((double)(flushStartTime - Time.monotonicNow()) / 1000.0, 0.001);
            xferCombined += writeSec;
            xferStats.append(String.format(" Synchronous (fsync) write to disk of " + ((File)streamPathMap.get(fileOutputStream)).getAbsolutePath() + " took %.2fs.", writeSec));
        }
        if (!finishedReceiving) {
            Util.deleteTmpFiles(localPaths);
        }
        if (finishedReceiving && received != advertisedSize) {
            Util.deleteTmpFiles(localPaths);
            throw new IOException("File " + url + " received length " + received + " is not of the advertised size " + advertisedSize + ". Fsimage name: " + fsImageName + " lastReceived: " + num);
        }
        xferStats.insert(0, String.format("Combined time for file download and fsync to all disks took %.2fs.", xferCombined));
        LOG.info((Object)xferStats.toString());
        if (digester != null) {
            MD5Hash computedDigest = new MD5Hash(digester.digest());
            if (advertisedDigest != null && !computedDigest.equals((Object)advertisedDigest)) {
                Util.deleteTmpFiles(localPaths);
                throw new IOException("File " + url + " computed digest " + computedDigest + " does not match advertised digest " + advertisedDigest);
            }
            return computedDigest;
        }
        return null;
    }

    private static void deleteTmpFiles(List<File> files) {
        if (files == null) {
            return;
        }
        LOG.info((Object)("Deleting temporary files: " + files));
        for (File file : files) {
            if (file.delete()) continue;
            LOG.warn((Object)("Deleting " + file + " has failed"));
        }
    }

    public static void setTimeout(HttpURLConnection connection, int timeout) {
        if (timeout > 0) {
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
        }
    }

    private static MD5Hash parseMD5Header(HttpURLConnection connection) {
        String header = connection.getHeaderField(MD5_HEADER);
        return header != null ? new MD5Hash(header) : null;
    }

    public static List<InetSocketAddress> getAddressesList(URI uri) throws IOException {
        String authority = uri.getAuthority();
        Preconditions.checkArgument((authority != null && !authority.isEmpty() ? 1 : 0) != 0, (Object)("URI has no authority: " + uri));
        String[] parts = StringUtils.split((String)authority, (char)';');
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim();
        }
        ArrayList addrs = Lists.newArrayList();
        for (String addr : parts) {
            InetSocketAddress isa = NetUtils.createSocketAddr((String)addr, (int)8485);
            if (isa.isUnresolved()) {
                throw new UnknownHostException(addr);
            }
            addrs.add(isa);
        }
        return addrs;
    }

    public static List<InetSocketAddress> getLoggerAddresses(URI uri, Set<InetSocketAddress> addrsToExclude) throws IOException {
        List<InetSocketAddress> addrsList = Util.getAddressesList(uri);
        addrsList.removeAll(addrsToExclude);
        return addrsList;
    }

    public static boolean isDiskStatsEnabled(int fileIOSamplingPercentage) {
        boolean isEnabled;
        if (fileIOSamplingPercentage <= 0) {
            LOG.info((Object)("dfs.datanode.fileio.profiling.sampling.percentage set to " + fileIOSamplingPercentage + ". Disabling file IO profiling"));
            isEnabled = false;
        } else {
            LOG.info((Object)("dfs.datanode.fileio.profiling.sampling.percentage set to " + fileIOSamplingPercentage + ". Enabling file IO profiling"));
            isEnabled = true;
        }
        return isEnabled;
    }

    static {
        Configuration conf = new Configuration();
        connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((Configuration)conf);
        isSpnegoEnabled = UserGroupInformation.isSecurityEnabled();
        IO_FILE_BUFFER_SIZE = DFSUtilClient.getIoFileBufferSize((Configuration)conf);
    }
}

