/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.util.CoreUtils;
import java.io.IOException;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class SemanticVersion
implements Comparable<SemanticVersion> {
    public static final String UNKNOWN_VERSION = "unknown";
    private final int major;
    private final int minor;
    private final int patch;
    private final String prerelease;
    private final String versionString;

    public static SemanticVersion getPackageVersionForClass(String className) {
        try {
            return SemanticVersion.getPackageVersion(Class.forName(className));
        }
        catch (Exception ignored) {
            return SemanticVersion.createInvalid();
        }
    }

    public static SemanticVersion parse(String version) {
        char ch;
        int patchEndIdx;
        Objects.requireNonNull(version, "'version' cannot be null.");
        int majorDotIdx = version.indexOf(46);
        if (majorDotIdx < 0) {
            return SemanticVersion.createInvalid(version);
        }
        int minorDotIdx = version.indexOf(46, majorDotIdx + 1);
        if (minorDotIdx < 0) {
            return SemanticVersion.createInvalid(version);
        }
        for (patchEndIdx = minorDotIdx + 1; patchEndIdx < version.length() && (ch = version.charAt(patchEndIdx)) != '.' && ch != '-' && ch != '+'; ++patchEndIdx) {
        }
        int extEndIdx = version.indexOf(43, patchEndIdx);
        if (extEndIdx < 0) {
            extEndIdx = version.length();
        }
        try {
            int major = Integer.parseInt(version.substring(0, majorDotIdx));
            int minor = Integer.parseInt(version.substring(majorDotIdx + 1, minorDotIdx));
            int patch = Integer.parseInt(version.substring(minorDotIdx + 1, patchEndIdx));
            String prerelease = patchEndIdx == extEndIdx ? "" : version.substring(patchEndIdx + 1, extEndIdx);
            return new SemanticVersion(major, minor, patch, prerelease, version);
        }
        catch (NumberFormatException ignored) {
            return SemanticVersion.createInvalid(version);
        }
    }

    private static SemanticVersion getPackageVersion(Class<?> clazz) {
        SemanticVersion semanticVersion;
        Objects.requireNonNull(clazz, "'clazz' cannot be null.");
        if (clazz.getPackage() == null) {
            return SemanticVersion.createInvalid();
        }
        String versionStr = clazz.getPackage().getImplementationVersion();
        if (versionStr != null) {
            return SemanticVersion.parse(versionStr);
        }
        JarFile jar = new JarFile(clazz.getProtectionDomain().getCodeSource().getLocation().getFile());
        try {
            Manifest manifest = jar.getManifest();
            versionStr = manifest.getMainAttributes().getValue("Implementation-Version");
            if (versionStr == null) {
                versionStr = manifest.getMainAttributes().getValue("Bundle-Version");
            }
            semanticVersion = SemanticVersion.parse(versionStr);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SecurityException ignored) {
                return SemanticVersion.createInvalid();
            }
        }
        jar.close();
        return semanticVersion;
    }

    public static SemanticVersion createInvalid() {
        return SemanticVersion.createInvalid(UNKNOWN_VERSION);
    }

    private static SemanticVersion createInvalid(String version) {
        return new SemanticVersion(-1, -1, -1, null, version);
    }

    SemanticVersion(int major, int minor, int patch, String prerelease, String versionString) {
        Objects.requireNonNull(versionString, "'versionString' cannot be null.");
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.prerelease = prerelease;
        this.versionString = versionString;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public int getMajorVersion() {
        return this.major;
    }

    @Override
    public int compareTo(SemanticVersion other) {
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return -1;
        }
        if (this.major != other.major) {
            return this.major > other.major ? 1 : -1;
        }
        if (this.minor != other.minor) {
            return this.minor > other.minor ? 1 : -1;
        }
        if (this.patch != other.patch) {
            return this.patch > other.patch ? 1 : -1;
        }
        if (CoreUtils.isNullOrEmpty(this.prerelease)) {
            return CoreUtils.isNullOrEmpty(other.prerelease) ? 0 : 1;
        }
        if (CoreUtils.isNullOrEmpty(other.prerelease)) {
            return -1;
        }
        return this.prerelease.compareTo(other.prerelease);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SemanticVersion)) {
            return false;
        }
        SemanticVersion otherVer = (SemanticVersion)other;
        return this.versionString.equals(otherVer.versionString);
    }

    public int hashCode() {
        return this.versionString.hashCode();
    }

    public String toString() {
        return this.versionString;
    }

    public boolean isValid() {
        return this.major >= 0;
    }
}

