/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.run;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.IExecutionConfiguration;
import org.apache.hop.core.Const;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.HopVersionProvider;
import org.apache.hop.core.config.plugin.ConfigPluginType;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.FileLoggingEventListener;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.IHopLoggingEventListener;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObject;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.JarCache;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataInstance;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.server.HopServerMeta;
import org.apache.hop.workflow.WorkflowExecutionConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEngineFactory;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=HopVersionProvider.class)
public class HopRun
implements Runnable,
IHasHopMetadataProvider {
    @CommandLine.Option(names={"-f", "--file"}, description={"The filename of the workflow or pipeline to run"})
    private String filename;
    @CommandLine.Option(names={"-l", "--level"}, description={"The debug level, one of NOTHING, ERROR, MINIMAL, BASIC, DETAILED, DEBUG, ROWLEVEL"})
    private String level;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Displays this help message and quits."})
    private boolean helpRequested;
    @CommandLine.Option(names={"-v", "--version"}, versionHelp=true, description={"Print version information and exit"})
    private boolean versionRequested;
    @CommandLine.Option(names={"-lf", "--logfile"}, description={"The complete filename where hop-run will write the Hop console log"})
    private String logFile;
    @CommandLine.Option(names={"-p", "--parameters"}, description={"A list of PARAMETER=VALUE pairs"})
    private String[] parameters = null;
    @CommandLine.Option(names={"-ps", "--parameters-separator"}, description={"A character to be used as separator for our list of PARAMETER=VALUE pairs (default is ,)"})
    private String parametersSeparator = null;
    @CommandLine.Option(names={"-s", "--system-properties"}, description={"A comma separated list of KEY=VALUE pairs"}, split=",")
    private String[] systemProperties = null;
    @CommandLine.Option(names={"-r", "--runconfig"}, description={"The name of the Run Configuration to use"})
    private String runConfigurationName = null;
    @CommandLine.Option(names={"-a", "--startaction"}, description={"The name of the action where to start a workflow"})
    private String startActionName = null;
    @CommandLine.Option(names={"-m", "--metadata-export"}, description={"A file containing exported metadata in JSON format"})
    private String metadataExportFile;
    @CommandLine.Option(names={"-o", "--printoptions"}, description={"Print the used options"})
    private boolean printingOptions = false;
    private IVariables variables = new Variables();
    private String realRunConfigurationName;
    private String realFilename;
    private CommandLine cmd;
    private ILogChannel log;
    private MultiMetadataProvider metadataProvider;
    private boolean finishedWithoutError;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.validateOptions();
        FileLoggingEventListener fileLoggingEventListener = null;
        try {
            this.log = new LogChannel((Object)"HopRun");
            this.log.setLogLevel(this.determineLogLevel());
            this.log.logDetailed("Start of Hop Run");
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopRunStart.id, (Object)this);
            Map mixins = this.cmd.getMixins();
            for (String key : mixins.keySet()) {
                Object mixin = mixins.get(key);
                if (!(mixin instanceof IConfigOptions)) continue;
                IConfigOptions configOptions = (IConfigOptions)mixin;
                configOptions.handleOption(this.log, (IHasHopMetadataProvider)this, this.variables);
            }
            String metadataExportFile = this.variables.resolve(this.getMetadataExportFile());
            if (StringUtils.isNotEmpty((String)metadataExportFile)) {
                try (InputStream inputStream = HopVfs.getInputStream((String)metadataExportFile);){
                    String json = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    SerializableMetadataProvider exportedProvider = new SerializableMetadataProvider(json);
                    this.metadataProvider.getProviders().add(exportedProvider);
                    System.out.println("===> Metadata provider is now: " + this.metadataProvider.getDescription());
                }
            }
            if (!Utils.isEmpty((CharSequence)this.logFile)) {
                fileLoggingEventListener = new FileLoggingEventListener(this.logFile, false);
                HopLogStore.getAppender().addLoggingEventListener((IHopLoggingEventListener)fileLoggingEventListener);
            }
            if (this.isPipeline()) {
                this.runPipeline(this.cmd, this.log);
            }
            if (this.isWorkflow()) {
                this.runWorkflow(this.cmd, this.log);
            }
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopRunEnd.id, (Object)this);
            if (fileLoggingEventListener == null) return;
        }
        catch (Exception e) {
            try {
                throw new CommandLine.ExecutionException(this.cmd, "There was an error during execution of file '" + this.filename + "'", (Throwable)e);
            }
            catch (Throwable throwable) {
                if (fileLoggingEventListener == null) throw throwable;
                HopLogStore.getAppender().removeLoggingEventListener(fileLoggingEventListener);
                throw throwable;
            }
        }
        HopLogStore.getAppender().removeLoggingEventListener((IHopLoggingEventListener)fileLoggingEventListener);
        return;
    }

    public void applySystemProperties() {
        if (this.systemProperties != null) {
            for (String parameter : this.systemProperties) {
                String value;
                String[] split = parameter.split("=", 2);
                String key = split.length > 0 ? split[0] : null;
                String string = value = split.length > 1 ? split[1] : null;
                if (!StringUtils.isNotEmpty((String)key) || !StringUtils.isNotEmpty((String)value)) continue;
                System.setProperty(key, value);
            }
        }
    }

    private void prepareInternalOptions(CommandLine cmd, String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("-h") && !arg.startsWith("--help")) continue;
            return;
        }
        String[] helpArgs = new String[args.length + 1];
        System.arraycopy(args, 0, helpArgs, 0, args.length);
        helpArgs[args.length] = "-h";
        cmd.parseArgs(helpArgs);
    }

    private void buildVariableSpace() {
        this.variables = Variables.getADefaultVariableSpace();
    }

    private void runPipeline(CommandLine cmd, ILogChannel log) {
        try {
            PipelineRunConfiguration defaultRunConfiguration;
            this.calculateRealFilename();
            PipelineMeta pipelineMeta = new PipelineMeta(this.realFilename, (IHopMetadataProvider)this.metadataProvider, this.variables);
            PipelineExecutionConfiguration configuration = new PipelineExecutionConfiguration();
            this.parseOptions(cmd, configuration, pipelineMeta);
            if (StringUtils.isEmpty((String)configuration.getRunConfiguration()) && (defaultRunConfiguration = PipelineRunConfiguration.findDefault((IHopMetadataProvider)this.metadataProvider)) != null) {
                configuration.setRunConfiguration(defaultRunConfiguration.getName());
            }
            if (this.printingOptions) {
                this.printOptions(configuration);
            }
            this.runPipeline(cmd, log, configuration, pipelineMeta);
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(cmd, "There was an error during execution of pipeline '" + this.filename + "'", (Throwable)e);
        }
    }

    private void calculateRealFilename() throws HopException {
        this.realFilename = this.variables.resolve(this.filename);
        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopRunCalculateFilename.id, (Object)this);
    }

    private void runPipeline(CommandLine cmd, ILogChannel log, PipelineExecutionConfiguration configuration, PipelineMeta pipelineMeta) {
        try {
            String pipelineRunConfigurationName = this.variables.resolve(configuration.getRunConfiguration());
            IPipelineEngine<PipelineMeta> pipeline = PipelineEngineFactory.createPipelineEngine(this.variables, pipelineRunConfigurationName, (IHopMetadataProvider)this.metadataProvider, pipelineMeta);
            pipeline.getPipelineMeta().setInternalHopVariables(pipeline);
            pipeline.initializeFrom(null);
            pipeline.setVariables(configuration.getVariablesMap());
            pipeline.copyParametersFromDefinitions(pipelineMeta);
            this.configureParametersAndVariables(cmd, configuration, pipeline, pipeline);
            pipeline.setLogLevel(configuration.getLogLevel());
            pipeline.setMetadataProvider((IHopMetadataProvider)this.metadataProvider);
            pipeline.activateParameters(pipeline);
            log.logMinimal("Starting pipeline: " + pipelineMeta.getFilename());
            pipeline.prepareExecution();
            pipeline.startThreads();
            pipeline.waitUntilFinished();
            this.setFinishedWithoutError(pipeline.getResult().getNrErrors() == 0L);
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(cmd, "Error running pipeline locally", (Throwable)e);
        }
    }

    private void runWorkflow(CommandLine cmd, ILogChannel log) {
        try {
            WorkflowRunConfiguration defaultRunConfiguration;
            this.calculateRealFilename();
            WorkflowMeta workflowMeta = new WorkflowMeta(this.variables, this.realFilename, (IHopMetadataProvider)this.metadataProvider);
            WorkflowExecutionConfiguration configuration = new WorkflowExecutionConfiguration();
            this.parseOptions(cmd, configuration, workflowMeta);
            if (StringUtils.isEmpty((String)configuration.getRunConfiguration()) && (defaultRunConfiguration = WorkflowRunConfiguration.findDefault((IHopMetadataProvider)this.metadataProvider)) != null) {
                configuration.setRunConfiguration(defaultRunConfiguration.getName());
            }
            configuration.setStartActionName(this.startActionName);
            ExtensionPointHandler.callExtensionPoint((ILogChannel)log, (IVariables)this.variables, (String)HopExtensionPoint.HopGuiWorkflowBeforeStart.id, (Object)new Object[]{configuration, null, workflowMeta, null});
            if (this.printingOptions) {
                this.printOptions(configuration);
            }
            this.runWorkflow(cmd, log, configuration, workflowMeta);
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(cmd, "There was an error during execution of workflow '" + this.filename + "'", (Throwable)e);
        }
    }

    private void runWorkflow(CommandLine cmd, ILogChannel log, WorkflowExecutionConfiguration configuration, WorkflowMeta workflowMeta) {
        try {
            String runConfigurationName = this.variables.resolve(configuration.getRunConfiguration());
            LoggingObject workflowLog = new LoggingObject((Object)log);
            workflowLog.setLogLevel(configuration.getLogLevel());
            IWorkflowEngine<WorkflowMeta> workflow = WorkflowEngineFactory.createWorkflowEngine(this.variables, runConfigurationName, (IHopMetadataProvider)this.metadataProvider, workflowMeta, (ILoggingObject)workflowLog);
            workflow.getWorkflowMeta().setInternalHopVariables(workflow);
            workflow.setVariables(configuration.getVariablesMap());
            workflow.copyParametersFromDefinitions(workflowMeta);
            this.configureParametersAndVariables(cmd, configuration, workflow, workflow);
            workflow.activateParameters(workflow);
            if (!Utils.isEmpty((CharSequence)configuration.getStartActionName())) {
                ActionMeta startActionMeta = workflowMeta.findAction(configuration.getStartActionName());
                if (startActionMeta == null) {
                    throw new CommandLine.ExecutionException(cmd, "Error running workflow, specified start action not found");
                }
                workflow.setStartActionMeta(startActionMeta);
            }
            log.logMinimal("Starting workflow: " + workflowMeta.getFilename());
            workflow.startExecution();
            this.setFinishedWithoutError(workflow.getResult().getResult());
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(cmd, "Error running workflow locally", (Throwable)e);
        }
    }

    private void parseOptions(CommandLine cmd, IExecutionConfiguration configuration, INamedParameterDefinitions namedParams) throws HopException {
        this.realRunConfigurationName = this.variables.resolve(this.runConfigurationName);
        configuration.setRunConfiguration(this.realRunConfigurationName);
        configuration.setLogLevel(this.determineLogLevel());
        this.parseParametersAndVariables(cmd, configuration, namedParams);
    }

    private LogLevel determineLogLevel() {
        return LogLevel.lookupCode((String)this.variables.resolve(this.level));
    }

    private void configureHopServer(IExecutionConfiguration configuration, String name) throws HopException {
        IHopMetadataSerializer serializer = this.metadataProvider.getSerializer(HopServerMeta.class);
        HopServerMeta hopServer = (HopServerMeta)serializer.load(name);
        if (hopServer == null) {
            throw new CommandLine.ParameterException(this.cmd, "Unable to find hop server '" + name + "' in the metadata");
        }
    }

    private boolean isPipeline() {
        if (StringUtils.isEmpty((String)this.filename)) {
            return false;
        }
        return this.filename.toLowerCase().endsWith(".hpl");
    }

    private boolean isWorkflow() {
        if (StringUtils.isEmpty((String)this.filename)) {
            return false;
        }
        return this.filename.toLowerCase().endsWith(".hwf");
    }

    private void parseParametersAndVariables(CommandLine cmd, IExecutionConfiguration configuration, INamedParameterDefinitions namedParams) {
        try {
            String[] availableParameters = namedParams.listParameters();
            if (this.parameters != null) {
                this.parametersSeparator = this.parametersSeparator == null ? "," : this.parametersSeparator;
                for (String parameter : this.parameters) {
                    for (String singleParameter : parameter.split(this.parametersSeparator)) {
                        String value;
                        String[] split = singleParameter.split("=", 2);
                        String key = split.length > 0 ? split[0] : null;
                        String string = value = split.length > 1 ? split[1] : null;
                        if (value != null && value.startsWith("\"") && value.endsWith("\"")) {
                            value = value.substring(1, value.length() - 1);
                        }
                        if (key == null) continue;
                        if (Const.indexOfString((String)key, (String[])availableParameters) < 0) {
                            configuration.getVariablesMap().put(key, value);
                            continue;
                        }
                        configuration.getParametersMap().put(key, value);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(cmd, "There was an error during execution of pipeline '" + this.filename + "'", (Throwable)e);
        }
    }

    private void configureParametersAndVariables(CommandLine cmd, IExecutionConfiguration configuration, IVariables variables, INamedParameters namedParams) {
        variables.setVariables(configuration.getVariablesMap());
        for (String key : namedParams.listParameters()) {
            String value = variables.getVariable(key);
            if (!StringUtils.isNotEmpty((String)value)) continue;
            try {
                namedParams.setParameterValue(key, value);
            }
            catch (UnknownParamException e) {
                throw new CommandLine.ParameterException(cmd, "Unable to set parameter '" + key + "'", (Throwable)e);
            }
        }
        for (String key : configuration.getParametersMap().keySet()) {
            String value = configuration.getParametersMap().get(key);
            try {
                namedParams.setParameterValue(key, value);
            }
            catch (UnknownParamException e) {
                throw new CommandLine.ParameterException(cmd, "Unable to set parameter '" + key + "'", (Throwable)e);
            }
        }
    }

    private void validateOptions() {
        if (StringUtils.isEmpty((String)this.filename)) {
            throw new CommandLine.ParameterException(new CommandLine((Object)this), "A filename is needed to run a workflow or pipeline");
        }
    }

    private void printOptions(IExecutionConfiguration configuration) {
        if (StringUtils.isNotEmpty((String)this.realFilename)) {
            this.log.logMinimal("OPTION: filename : '" + this.realFilename + "'");
        }
        if (StringUtils.isNotEmpty((String)configuration.getRunConfiguration())) {
            this.log.logMinimal("OPTION: run configuration : '" + configuration.getRunConfiguration() + "'");
        }
        this.log.logMinimal("OPTION: Logging level : " + configuration.getLogLevel().getDescription());
        if (!configuration.getVariablesMap().isEmpty()) {
            this.log.logMinimal("OPTION: Variables: ");
            for (String variable : configuration.getVariablesMap().keySet()) {
                this.log.logMinimal("  " + variable + " : '" + configuration.getVariablesMap().get(variable));
            }
        }
        if (!configuration.getParametersMap().isEmpty()) {
            this.log.logMinimal("OPTION: Parameters: ");
            for (String parameter : configuration.getParametersMap().keySet()) {
                this.log.logMinimal("OPTION:   " + parameter + " : '" + configuration.getParametersMap().get(parameter));
            }
        }
    }

    public ILogChannel getLog() {
        return this.log;
    }

    public MultiMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public CommandLine getCmd() {
        return this.cmd;
    }

    public void setCmd(CommandLine cmd) {
        this.cmd = cmd;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public boolean isHelpRequested() {
        return this.helpRequested;
    }

    public void setHelpRequested(boolean helpRequested) {
        this.helpRequested = helpRequested;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void setParameters(String[] parameters) {
        this.parameters = parameters;
    }

    public String getRunConfigurationName() {
        return this.runConfigurationName;
    }

    public void setRunConfigurationName(String runConfigurationName) {
        this.runConfigurationName = runConfigurationName;
    }

    public boolean isPrintingOptions() {
        return this.printingOptions;
    }

    public void setPrintingOptions(boolean printingOptions) {
        this.printingOptions = printingOptions;
    }

    public String[] getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(String[] systemProperties) {
        this.systemProperties = systemProperties;
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public String getRealRunConfigurationName() {
        return this.realRunConfigurationName;
    }

    public void setRealRunConfigurationName(String realRunConfigurationName) {
        this.realRunConfigurationName = realRunConfigurationName;
    }

    public String getRealFilename() {
        return this.realFilename;
    }

    public void setRealFilename(String realFilename) {
        this.realFilename = realFilename;
    }

    public void setLog(ILogChannel log) {
        this.log = log;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void setMetadataProvider(MultiMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public boolean isFinishedWithoutError() {
        return this.finishedWithoutError;
    }

    public void setFinishedWithoutError(boolean finishedWithoutError) {
        this.finishedWithoutError = finishedWithoutError;
    }

    public String getMetadataExportFile() {
        return this.metadataExportFile;
    }

    public void setMetadataExportFile(String metadataExportFile) {
        this.metadataExportFile = metadataExportFile;
    }

    public static void main(String[] args) {
        HopRun hopRun = new HopRun();
        try {
            CommandLine cmd = new CommandLine((Object)hopRun);
            if (args.length > 0) {
                hopRun.prepareInternalOptions(new CommandLine((Object)hopRun), args);
            }
            hopRun.applySystemProperties();
            HopEnvironment.init();
            hopRun.buildVariableSpace();
            HopLogStore.init();
            JarCache.getInstance().clear();
            hopRun.metadataProvider = HopMetadataUtil.getStandardHopMetadataProvider((IVariables)hopRun.variables);
            HopMetadataInstance.setMetadataProvider((MultiMetadataProvider)hopRun.metadataProvider);
            List configPlugins = PluginRegistry.getInstance().getPlugins(ConfigPluginType.class);
            for (IPlugin configPlugin : configPlugins) {
                if (!"run".equals(configPlugin.getCategory())) continue;
                IConfigOptions configOptions = (IConfigOptions)PluginRegistry.getInstance().loadClass(configPlugin, IConfigOptions.class);
                cmd.addMixin(configPlugin.getIds()[0], (Object)configOptions);
            }
            hopRun.setCmd(cmd);
            CommandLine.ParseResult parseResult = cmd.parseArgs(args);
            if (CommandLine.printHelpIfRequested((CommandLine.ParseResult)parseResult)) {
                System.exit(1);
            } else {
                hopRun.run();
                System.out.println("HopRun exit.");
                if (hopRun.isFinishedWithoutError()) {
                    System.exit(0);
                } else {
                    System.exit(1);
                }
            }
        }
        catch (CommandLine.ParameterException e) {
            System.err.println(e.getMessage());
            hopRun.cmd.usage(System.err);
            System.exit(9);
        }
        catch (CommandLine.ExecutionException e) {
            System.err.println("Error found during execution!");
            System.err.println(Const.getStackTracker((Throwable)e));
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("General error found, something went horribly wrong!");
            System.err.println(Const.getStackTracker((Throwable)e));
            System.exit(2);
        }
    }
}

