/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cubeoutput;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cubeoutput.CubeOutputData;
import org.apache.hop.pipeline.transforms.cubeoutput.CubeOutputMeta;

public class CubeOutput
extends BaseTransform<CubeOutputMeta, CubeOutputData> {
    private static final Class<?> PKG = CubeOutputMeta.class;

    public CubeOutput(TransformMeta transformMeta, CubeOutputMeta meta, CubeOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        boolean result = true;
        Object[] r = this.getRow();
        if (this.first) {
            ((CubeOutputData)this.data).outputMeta = this.getInputRowMeta() != null ? this.getInputRowMeta().clone() : this.getPipelineMeta().getPrevTransformFields((IVariables)this, this.getTransformMeta());
            if (r == null && ((CubeOutputData)this.data).oneFileOpened && !(result = this.writeHeaderToFile())) {
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
        }
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            if (((CubeOutputMeta)this.meta).isDoNotOpenNewFileInit()) {
                try {
                    this.prepareFile();
                    ((CubeOutputData)this.data).oneFileOpened = true;
                }
                catch (HopFileException ioe) {
                    this.logError(BaseMessages.getString(PKG, (String)"CubeOutput.Log.ErrorOpeningCubeOutputFile", (String[])new String[0]) + ioe.toString());
                    this.setErrors(1L);
                    return false;
                }
            }
            if (!(result = this.writeHeaderToFile())) {
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            this.first = false;
        }
        if (!(result = this.writeRowToFile(r))) {
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
        this.putRow(((CubeOutputData)this.data).outputMeta, r);
        if (this.checkFeedback(this.getLinesOutput()) && this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"CubeOutput.Log.LineNumber", (String[])new String[0]) + this.getLinesOutput());
        }
        return result;
    }

    private synchronized boolean writeHeaderToFile() {
        try {
            ((CubeOutputData)this.data).outputMeta.writeMeta(((CubeOutputData)this.data).dos);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"CubeOutput.Log.ErrorWritingLine", (String[])new String[0]) + e.toString());
            return false;
        }
        return true;
    }

    private synchronized boolean writeRowToFile(Object[] r) {
        try {
            ((CubeOutputData)this.data).outputMeta.writeData(((CubeOutputData)this.data).dos, r);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"CubeOutput.Log.ErrorWritingLine", (String[])new String[0]) + e.toString());
            return false;
        }
        this.incrementLinesOutput();
        return true;
    }

    public boolean init() {
        if (super.init()) {
            if (!((CubeOutputMeta)this.meta).isDoNotOpenNewFileInit()) {
                try {
                    this.prepareFile();
                    ((CubeOutputData)this.data).oneFileOpened = true;
                    return true;
                }
                catch (HopFileException ioe) {
                    this.logError(BaseMessages.getString(PKG, (String)"CubeOutput.Log.ErrorOpeningCubeOutputFile", (String[])new String[0]) + ioe.toString());
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private void prepareFile() throws HopFileException {
        try {
            String filename = this.resolve(((CubeOutputMeta)this.meta).getFilename());
            FileObject fileObject = HopVfs.getFileObject((String)filename, (IVariables)this.variables);
            if (((CubeOutputMeta)this.meta).isFilenameCreatingParentFolders()) {
                this.createParentFolder(fileObject.getParent());
            }
            if (((CubeOutputMeta)this.meta).isAddToResultFilenames()) {
                ResultFile resultFile = new ResultFile(0, fileObject, this.getPipelineMeta().getName(), this.getTransformName());
                resultFile.setComment("This file was created with a cube file output transform");
                this.addResultFile(resultFile);
            }
            ((CubeOutputData)this.data).fos = HopVfs.getOutputStream((String)filename, (boolean)false, (IVariables)this.variables);
            ((CubeOutputData)this.data).zip = new GZIPOutputStream(((CubeOutputData)this.data).fos);
            ((CubeOutputData)this.data).dos = new DataOutputStream(((CubeOutputData)this.data).zip);
        }
        catch (Exception e) {
            throw new HopFileException((Throwable)e);
        }
    }

    private void createParentFolder(FileObject parentFolder) throws HopTransformException {
        if (parentFolder == null) {
            return;
        }
        try {
            if (!parentFolder.exists()) {
                this.createParentFolder(parentFolder.getParent());
                parentFolder.createFolder();
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"CubeOutput.Log.ParentFolderCreated", (Object[])new Object[]{parentFolder.getName()}));
                }
            }
        }
        catch (Exception e) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"CubeOutput.Error.ErrorCreatingParentFolder", (Object[])new Object[]{parentFolder.getName()}));
        }
        finally {
            if (parentFolder != null) {
                try {
                    parentFolder.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void dispose() {
        if (((CubeOutputData)this.data).oneFileOpened) {
            try {
                if (((CubeOutputData)this.data).dos != null) {
                    ((CubeOutputData)this.data).dos.close();
                    ((CubeOutputData)this.data).dos = null;
                }
                if (((CubeOutputData)this.data).zip != null) {
                    ((CubeOutputData)this.data).zip.close();
                    ((CubeOutputData)this.data).zip = null;
                }
                if (((CubeOutputData)this.data).fos != null) {
                    ((CubeOutputData)this.data).fos.close();
                    ((CubeOutputData)this.data).fos = null;
                }
            }
            catch (IOException e) {
                this.logError(BaseMessages.getString(PKG, (String)"CubeOutput.Log.ErrorClosingFile", (String[])new String[0]) + ((CubeOutputMeta)this.meta).getFilename());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        super.dispose();
    }
}

