/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.util.Clock;
import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubReadSchemaTransformConfiguration;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.utils.JsonUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class PubsubReadSchemaTransformProvider
extends TypedSchemaTransformProvider<PubsubReadSchemaTransformConfiguration> {
    public static final @UnknownKeyFor @NonNull @Initialized String VALID_FORMATS_STR = "RAW,AVRO,JSON";
    public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> VALID_DATA_FORMATS = Sets.newHashSet((Object[])"RAW,AVRO,JSON".split(","));
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> OUTPUT_TAG = new TupleTag<Row>(){};
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> ERROR_TAG = new TupleTag<Row>(){};
    public static final @UnknownKeyFor @NonNull @Initialized Schema ERROR_SCHEMA = Schema.builder().addStringField("error").addNullableByteArrayField("row").build();

    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized PubsubReadSchemaTransformConfiguration> configurationClass() {
        return PubsubReadSchemaTransformConfiguration.class;
    }

    public @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized PubsubReadSchemaTransformConfiguration configuration) {
        SimpleFunction payloadMapper;
        Schema payloadSchema;
        String format;
        if (configuration.getSubscription() == null && configuration.getTopic() == null) {
            throw new IllegalArgumentException("To read from Pubsub, a subscription name or a topic name must be provided");
        }
        if (configuration.getSubscription() != null && configuration.getTopic() != null) {
            throw new IllegalArgumentException("To read from Pubsub, a subscription name or a topic name must be provided. Not both.");
        }
        if (!"RAW".equals(configuration.getFormat()) && (Strings.isNullOrEmpty((String)configuration.getSchema()) && !Strings.isNullOrEmpty((String)configuration.getFormat()) || !Strings.isNullOrEmpty((String)configuration.getSchema()) && Strings.isNullOrEmpty((String)configuration.getFormat()))) {
            throw new IllegalArgumentException("A schema was provided without a data format (or viceversa). Please provide both of these parameters to read from Pubsub, or if you would like to use the Pubsub schema service, please leave both of these blank.");
        }
        String string = format = configuration.getFormat() == null ? null : configuration.getFormat().toUpperCase();
        if ("RAW".equals(format)) {
            payloadSchema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"payload", (Schema.FieldType)Schema.FieldType.BYTES)});
            payloadMapper = input -> Row.withSchema((Schema)payloadSchema).addValue(input).build();
        } else if ("JSON".equals(format)) {
            payloadSchema = JsonUtils.beamSchemaFromJsonSchema((String)configuration.getSchema());
            payloadMapper = JsonUtils.getJsonBytesToRowFunction((Schema)payloadSchema);
        } else if ("AVRO".equals(format)) {
            payloadSchema = AvroUtils.toBeamSchema((org.apache.avro.Schema)new Schema.Parser().parse(configuration.getSchema()));
            payloadMapper = AvroUtils.getAvroBytesToRowFunction((Schema)payloadSchema);
        } else {
            throw new IllegalArgumentException(String.format("Format %s not supported. Only supported formats are %s", configuration.getFormat(), VALID_FORMATS_STR));
        }
        PubsubReadSchemaTransform transform = new PubsubReadSchemaTransform(configuration, payloadSchema, (SerializableFunction<byte[], Row>)payloadMapper);
        if (configuration.getClientFactory() != null) {
            transform.setClientFactory(configuration.getClientFactory());
        }
        if (configuration.getClock() != null) {
            transform.setClock(configuration.getClock());
        }
        return transform;
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:pubsub_read:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.emptyList();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Arrays.asList("output", "errors");
    }

    private static class PubsubReadSchemaTransform
    extends SchemaTransform
    implements Serializable {
        final @UnknownKeyFor @NonNull @Initialized Schema beamSchema;
        final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> valueMapper;
        final @UnknownKeyFor @NonNull @Initialized PubsubReadSchemaTransformConfiguration configuration;
         @Nullable @UnknownKeyFor @Initialized PubsubTestClient.PubsubTestClientFactory clientFactory;
        @Nullable @UnknownKeyFor @Initialized Clock clock;

        PubsubReadSchemaTransform(@UnknownKeyFor @NonNull @Initialized PubsubReadSchemaTransformConfiguration configuration, @UnknownKeyFor @NonNull @Initialized Schema payloadSchema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> valueMapper) {
            Schema outputSchema;
            this.configuration = configuration;
            List<String> attributes = configuration.getAttributes();
            String attributesMap = configuration.getAttributesMap();
            if (attributes == null && attributesMap == null) {
                outputSchema = payloadSchema;
            } else {
                Schema.Builder outputSchemaBuilder = Schema.builder();
                outputSchemaBuilder.addFields(payloadSchema.getFields());
                if (attributes != null) {
                    for (String attribute : attributes) {
                        outputSchemaBuilder.addStringField(attribute);
                    }
                }
                if (attributesMap != null) {
                    outputSchemaBuilder.addMapField(attributesMap, Schema.FieldType.STRING, Schema.FieldType.STRING);
                }
                outputSchema = outputSchemaBuilder.build();
            }
            this.beamSchema = outputSchema;
            this.valueMapper = valueMapper;
        }

        void setClientFactory( @Nullable @UnknownKeyFor @Initialized PubsubTestClient.PubsubTestClientFactory factory) {
            this.clientFactory = factory;
        }

        void setClock(@Nullable @UnknownKeyFor @Initialized Clock clock) {
            this.clock = clock;
        }

        @UnknownKeyFor @NonNull @Initialized PubsubIO.Read<@UnknownKeyFor @NonNull @Initialized PubsubMessage> buildPubsubRead() {
            PubsubIO.Read<PubsubMessage> pubsubRead = this.configuration.getAttributes() == null && this.configuration.getAttributesMap() == null ? PubsubIO.readMessages() : PubsubIO.readMessagesWithAttributes();
            pubsubRead = !Strings.isNullOrEmpty((String)this.configuration.getTopic()) ? pubsubRead.fromTopic(this.configuration.getTopic()) : pubsubRead.fromSubscription(this.configuration.getSubscription());
            if (this.clientFactory != null && this.clock != null) {
                pubsubRead = pubsubRead.withClientFactory(this.clientFactory);
                pubsubRead = this.clientFactory.setClock(pubsubRead, this.clock);
            } else if (this.clientFactory != null || this.clock != null) {
                throw new IllegalArgumentException("Both PubsubTestClientFactory and Clock need to be specified for testing, but only one is provided");
            }
            if (!Strings.isNullOrEmpty((String)this.configuration.getIdAttribute())) {
                pubsubRead = pubsubRead.withIdAttribute(this.configuration.getIdAttribute());
            }
            if (!Strings.isNullOrEmpty((String)this.configuration.getTimestampAttribute())) {
                pubsubRead = pubsubRead.withTimestampAttribute(this.configuration.getTimestampAttribute());
            }
            return pubsubRead;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            PubsubIO.Read<PubsubMessage> pubsubRead = this.buildPubsubRead();
            String errorOutput = this.configuration.getErrorHandling() == null ? null : this.configuration.getErrorHandling().getOutput();
            PCollectionTuple outputTuple = (PCollectionTuple)((PCollection)input.getPipeline().apply(pubsubRead)).apply((PTransform)ParDo.of((DoFn)new ErrorCounterFn("PubSub-read-error-counter", this.valueMapper, this.configuration.getAttributes(), this.configuration.getAttributesMap(), this.beamSchema, errorOutput != null)).withOutputTags(OUTPUT_TAG, TupleTagList.of(ERROR_TAG)));
            outputTuple.get(OUTPUT_TAG).setRowSchema(this.beamSchema);
            outputTuple.get(ERROR_TAG).setRowSchema(ERROR_SCHEMA);
            PCollectionRowTuple result = PCollectionRowTuple.of((String)"output", (PCollection)outputTuple.get(OUTPUT_TAG));
            if (errorOutput == null) {
                return result;
            }
            return result.and(errorOutput, outputTuple.get(ERROR_TAG));
        }

        private static class ErrorCounterFn
        extends DoFn<PubsubMessage, Row> {
            private final @UnknownKeyFor @NonNull @Initialized Counter pubsubErrorCounter;
            private @UnknownKeyFor @NonNull @Initialized Long errorsInBundle = 0L;
            private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> valueMapper;
            private final @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> attributes;
            private final @Nullable @UnknownKeyFor @Initialized String attributesMap;
            private final @UnknownKeyFor @NonNull @Initialized Schema outputSchema;
            final @UnknownKeyFor @NonNull @Initialized boolean useErrorOutput;

            ErrorCounterFn(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> valueMapper, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> attributes, @Nullable @UnknownKeyFor @Initialized String attributesMap, @UnknownKeyFor @NonNull @Initialized Schema outputSchema, @UnknownKeyFor @NonNull @Initialized boolean useErrorOutput) {
                this.pubsubErrorCounter = Metrics.counter(PubsubReadSchemaTransformProvider.class, (String)name);
                this.valueMapper = valueMapper;
                this.attributes = attributes;
                this.attributesMap = attributesMap;
                this.outputSchema = outputSchema;
                this.useErrorOutput = useErrorOutput;
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @DoFn.ProcessElement
            public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized PubsubMessage message, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver receiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
                try {
                    Row outputRow;
                    Row payloadRow = (Row)this.valueMapper.apply((Object)message.getPayload());
                    if (this.attributes == null && this.attributesMap == null) {
                        outputRow = payloadRow;
                    } else {
                        Row.Builder rowBuilder = Row.withSchema((Schema)this.outputSchema);
                        @Nullable List payloadValues = payloadRow.getValues();
                        if (payloadValues != null) {
                            rowBuilder.addValues(payloadValues);
                        }
                        if (this.attributes != null) {
                            for (String attribute : this.attributes) {
                                rowBuilder.addValue((Object)message.getAttribute(attribute));
                            }
                        }
                        if (this.attributesMap != null) {
                            rowBuilder.addValue(message.getAttributeMap());
                        }
                        outputRow = rowBuilder.build();
                    }
                    receiver.get(OUTPUT_TAG).output((Object)outputRow);
                }
                catch (Exception e) {
                    this.errorsInBundle = this.errorsInBundle + 1L;
                    if (this.useErrorOutput) {
                        receiver.get(ERROR_TAG).output((Object)Row.withSchema((Schema)ERROR_SCHEMA).addValues(new Object[]{e.toString(), message.getPayload()}).build());
                    }
                    throw e;
                }
            }

            @DoFn.FinishBundle
            public void finish(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) {
                this.pubsubErrorCounter.inc(this.errorsInBundle.longValue());
                this.errorsInBundle = 0L;
            }
        }
    }
}

