/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.JDFieldMap;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.SQLDataFactory;
import java.sql.SQLException;

class JDTypeInfoFieldMap
implements JDFieldMap {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private int lengthIndex_;
    private int precisionIndex_;
    private int scaleIndex_;
    private int typeIndex_;
    private JDProperties properties_;
    private int vrm_;
    private int ccsidIndex_;

    JDTypeInfoFieldMap(int typeIndex, int lengthIndex, int precisionIndex, int scaleIndex, int ccsidIndex, int vrm, JDProperties properties) {
        this.typeIndex_ = typeIndex;
        this.lengthIndex_ = lengthIndex;
        this.precisionIndex_ = precisionIndex;
        this.scaleIndex_ = scaleIndex;
        this.properties_ = properties;
        this.vrm_ = vrm;
        this.ccsidIndex_ = ccsidIndex;
    }

    @Override
    public Object getValue(JDRow row) throws SQLException {
        String typeName = row.getSQLData(this.typeIndex_).getString().trim();
        int length = row.getSQLData(this.lengthIndex_).getInt();
        if ("DBCLOB".equals(typeName) || "GRAPHIC".equals(typeName) || "VARG".equals(typeName) || "VARGRAPHIC".equals(typeName)) {
            length *= 2;
        }
        int precision = row.getSQLData(this.precisionIndex_).getInt();
        int scale = row.getSQLData(this.scaleIndex_).getInt();
        int ccsid = 0;
        if (this.ccsidIndex_ != 0) {
            ccsid = row.getSQLData(this.ccsidIndex_).getInt();
        }
        return SQLDataFactory.newData(typeName, length, precision, scale, ccsid, null, this.vrm_, this.properties_);
    }

    @Override
    public boolean isDataMappingError(JDRow row) throws SQLException {
        return false;
    }

    @Override
    public boolean isNull(JDRow row) throws SQLException {
        return false;
    }
}

