/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.action;

import org.apache.hop.core.Const;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.debug.action.ActionDebugLevel;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ActionDebugLevelDialog
extends Dialog {
    private static final Class<?> PKG = ActionDebugLevelDialog.class;
    private ActionDebugLevel input;
    private ActionDebugLevel debugLevel;
    private Shell shell;
    private Combo wLogLevel;
    private Button wLoggingResult;
    private Button wLoggingVariables;
    private Button wLoggingRows;
    private Button wLoggingFiles;
    private PropsUi props;
    private boolean ok;

    public ActionDebugLevelDialog(Shell par, ActionDebugLevel debugLevel) {
        super(par, 0);
        this.input = debugLevel;
        this.props = PropsUi.getInstance();
        this.ok = false;
        this.debugLevel = this.input.clone();
    }

    public boolean open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageServer());
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin() + 2;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setText("Workflow action debug Level");
        this.shell.setLayout((Layout)formLayout);
        Label wlName = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText("Log level ");
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wLogLevel = new Combo((Composite)this.shell, 18436);
        this.wLogLevel.setItems(LogLevel.getLogLevelDescriptions());
        PropsUi.setLook((Widget)this.wLogLevel);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment(100, 0);
        this.wLogLevel.setLayoutData((Object)fdName);
        Combo lastControl = this.wLogLevel;
        Label wlLoggingResult = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlLoggingResult);
        wlLoggingResult.setText("Log result?");
        FormData fdlLoggingResult = new FormData();
        fdlLoggingResult.top = new FormAttachment((Control)lastControl, margin);
        fdlLoggingResult.left = new FormAttachment(0, 0);
        fdlLoggingResult.right = new FormAttachment(middle, -margin);
        wlLoggingResult.setLayoutData((Object)fdlLoggingResult);
        this.wLoggingResult = new Button((Composite)this.shell, 16416);
        PropsUi.setLook((Widget)this.wLoggingResult);
        FormData fdLoggingResult = new FormData();
        fdLoggingResult.top = new FormAttachment((Control)wlLoggingResult, 0, 0x1000000);
        fdLoggingResult.left = new FormAttachment(middle, 0);
        fdLoggingResult.right = new FormAttachment(100, 0);
        this.wLoggingResult.setLayoutData((Object)fdLoggingResult);
        lastControl = this.wLoggingResult;
        Label wlLoggingVariables = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlLoggingVariables);
        wlLoggingVariables.setText("Log variables?");
        FormData fdlLoggingVariables = new FormData();
        fdlLoggingVariables.top = new FormAttachment((Control)lastControl, margin);
        fdlLoggingVariables.left = new FormAttachment(0, 0);
        fdlLoggingVariables.right = new FormAttachment(middle, -margin);
        wlLoggingVariables.setLayoutData((Object)fdlLoggingVariables);
        this.wLoggingVariables = new Button((Composite)this.shell, 16416);
        PropsUi.setLook((Widget)this.wLoggingVariables);
        FormData fdLoggingVariables = new FormData();
        fdLoggingVariables.top = new FormAttachment((Control)wlLoggingVariables, 0, 0x1000000);
        fdLoggingVariables.left = new FormAttachment(middle, 0);
        fdLoggingVariables.right = new FormAttachment(100, 0);
        this.wLoggingVariables.setLayoutData((Object)fdLoggingVariables);
        lastControl = this.wLoggingVariables;
        Label wlLoggingRows = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlLoggingRows);
        wlLoggingRows.setText("Log result rows?");
        FormData fdlLoggingRows = new FormData();
        fdlLoggingRows.top = new FormAttachment((Control)lastControl, margin);
        fdlLoggingRows.left = new FormAttachment(0, 0);
        fdlLoggingRows.right = new FormAttachment(middle, -margin);
        wlLoggingRows.setLayoutData((Object)fdlLoggingRows);
        this.wLoggingRows = new Button((Composite)this.shell, 16416);
        PropsUi.setLook((Widget)this.wLoggingRows);
        FormData fdLoggingRows = new FormData();
        fdLoggingRows.top = new FormAttachment((Control)wlLoggingRows, 0, 0x1000000);
        fdLoggingRows.left = new FormAttachment(middle, 0);
        fdLoggingRows.right = new FormAttachment(100, 0);
        this.wLoggingRows.setLayoutData((Object)fdLoggingRows);
        lastControl = this.wLoggingRows;
        Label wlLoggingFiles = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlLoggingFiles);
        wlLoggingFiles.setText("Log result files?");
        FormData fdlLoggingFiles = new FormData();
        fdlLoggingFiles.top = new FormAttachment((Control)lastControl, margin);
        fdlLoggingFiles.left = new FormAttachment(0, 0);
        fdlLoggingFiles.right = new FormAttachment(middle, -margin);
        wlLoggingFiles.setLayoutData((Object)fdlLoggingFiles);
        this.wLoggingFiles = new Button((Composite)this.shell, 16416);
        PropsUi.setLook((Widget)this.wLoggingFiles);
        FormData fdLoggingFiles = new FormData();
        fdLoggingFiles.top = new FormAttachment((Control)wlLoggingFiles, 0, 0x1000000);
        fdLoggingFiles.left = new FormAttachment(middle, 0);
        fdLoggingFiles.right = new FormAttachment(100, 0);
        this.wLoggingFiles.setLayoutData((Object)fdLoggingFiles);
        lastControl = this.wLoggingFiles;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, (Control)lastControl);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.ok;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wLogLevel.setText(this.debugLevel.getLogLevel().getDescription());
        this.wLoggingResult.setSelection(this.debugLevel.isLoggingResult());
        this.wLoggingVariables.setSelection(this.debugLevel.isLoggingVariables());
        this.wLoggingRows.setSelection(this.debugLevel.isLoggingResultRows());
        this.wLoggingFiles.setSelection(this.debugLevel.isLoggingResultFiles());
        this.wLogLevel.setFocus();
    }

    private void cancel() {
        this.ok = false;
        this.dispose();
    }

    public void ok() {
        this.getInfo(this.input);
        this.ok = true;
        this.dispose();
    }

    private void getInfo(ActionDebugLevel level) {
        int index = Const.indexOfString((String)this.wLogLevel.getText(), (String[])LogLevel.getLogLevelDescriptions());
        level.setLogLevel(LogLevel.values()[index]);
        level.setLoggingResult(this.wLoggingResult.getSelection());
        level.setLoggingVariables(this.wLoggingVariables.getSelection());
        level.setLoggingResultRows(this.wLoggingRows.getSelection());
        level.setLoggingResultFiles(this.wLoggingFiles.getSelection());
    }
}

