/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.workflow;

import java.util.Date;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;

@ExtensionPoint(id="LogWorkflowExecutionTimeExtensionPoint", description="Logs execution time of a workflow when it finishes", extensionPointId="WorkflowStart")
public class LogWorkflowExecutionTimeExtensionPoint
implements IExtensionPoint<IWorkflowEngine<WorkflowMeta>> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, IWorkflowEngine<WorkflowMeta> workflow) throws HopException {
        String durationVariable = workflow.getVariable("HOP_DEBUG_DURATION", "Y");
        if ("N".equalsIgnoreCase(durationVariable) || "FALSE".equalsIgnoreCase(durationVariable)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        workflow.addExecutionFinishedListener(workflow1 -> {
            Date startDate = workflow1.getExecutionStartDate();
            Date endDate = workflow1.getExecutionEndDate();
            if (startDate != null && endDate != null) {
                long startTime1 = startDate.getTime();
                long endTime = endDate.getTime();
                double seconds = ((double)endTime - (double)startTime1) / 1000.0;
                log.logBasic("Workflow duration : " + seconds + " seconds [ " + Utils.getDurationHMS((double)seconds) + " ]");
            }
        });
    }
}

