/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.loginfo;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import org.apache.hop.core.Const;

public class Management {
    private static RuntimeMXBean mx = null;
    private static OperatingSystemMXBean bean = null;
    private static ThreadMXBean tbean = null;

    public static long getPID() {
        int indexOf;
        String pid = null;
        if (mx == null) {
            mx = ManagementFactory.getRuntimeMXBean();
        }
        if ((indexOf = (pid = mx.getName()).indexOf("@")) > 0) {
            pid = pid.substring(0, indexOf);
        }
        return Const.toInt((String)pid, (int)-1);
    }

    public static long getJVMCpuTime() {
        Management.setOperatingSystemMXBean();
        return bean.getProcessCpuTime();
    }

    public static long getFreePhysicalMemorySize() {
        Management.setOperatingSystemMXBean();
        return bean.getFreePhysicalMemorySize();
    }

    public static long getFreeSwapSpaceSize() {
        Management.setOperatingSystemMXBean();
        return bean.getFreeSwapSpaceSize();
    }

    public static long getTotalPhysicalMemorySize() {
        Management.setOperatingSystemMXBean();
        return bean.getTotalPhysicalMemorySize();
    }

    public static long getTotalSwapSpaceSize() {
        Management.setOperatingSystemMXBean();
        return bean.getTotalSwapSpaceSize();
    }

    public static long getCommittedVirtualMemorySize() {
        Management.setOperatingSystemMXBean();
        return bean.getCommittedVirtualMemorySize();
    }

    public static long getCpuTime(long id) {
        Management.setThreadMXBean();
        if (!tbean.isThreadCpuTimeSupported()) {
            return 0L;
        }
        return tbean.getThreadCpuTime(id);
    }

    private static void setOperatingSystemMXBean() {
        if (bean == null) {
            bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        }
    }

    private static void setThreadMXBean() {
        if (tbean == null) {
            tbean = ManagementFactory.getThreadMXBean();
        }
    }
}

