/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class RowWithGetters<@UnknownKeyFor T>
extends Row {
    private final T getterTarget;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Object>> getters;
    private @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @Nullable @UnknownKeyFor @Initialized Object> cache = null;

    RowWithGetters(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Object>>> getterFactory, T getterTarget) {
        super(schema);
        this.getterTarget = getterTarget;
        this.getters = getterFactory.create(TypeDescriptor.of(getterTarget.getClass()), schema);
    }

    public <W> W getValue(@UnknownKeyFor @NonNull @Initialized int fieldIdx) {
        Object fieldValue;
        Schema.Field field = this.getSchema().getField(fieldIdx);
        boolean cacheField = this.cacheFieldType(field);
        if (cacheField && this.cache == null) {
            this.cache = new TreeMap<Integer, Object>();
        }
        if (cacheField) {
            if (this.cache == null) {
                this.cache = new TreeMap<Integer, Object>();
            }
            fieldValue = this.cache.computeIfAbsent(fieldIdx, new Function<Integer, Object>(){

                @Override
                public @Nullable @UnknownKeyFor @Initialized Object apply(@UnknownKeyFor @NonNull @Initialized Integer idx) {
                    FieldValueGetter getter = (FieldValueGetter)RowWithGetters.this.getters.get(idx);
                    Preconditions.checkStateNotNull(getter);
                    return getter.get(RowWithGetters.this.getterTarget);
                }
            });
        } else {
            fieldValue = this.getters.get(fieldIdx).get(this.getterTarget);
        }
        if (fieldValue == null && !field.getType().getNullable().booleanValue()) {
            throw new RuntimeException("Null value set on non-nullable field " + field);
        }
        return (W)fieldValue;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean cacheFieldType(@UnknownKeyFor @NonNull @Initialized Schema.Field field) {
        Schema.TypeName typeName = field.getType().getTypeName();
        return typeName.equals((Object)Schema.TypeName.MAP) || typeName.equals((Object)Schema.TypeName.ARRAY) || typeName.equals((Object)Schema.TypeName.ITERABLE);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int getFieldCount() {
        return this.getters.size();
    }

    @Override
    @Internal
    public @UnknownKeyFor @NonNull @Initialized List<@Nullable @UnknownKeyFor @Initialized Object> getValues() {
        ArrayList<@Nullable Object> rawValues = new ArrayList<Object>(this.getters.size());
        for (FieldValueGetter<T, Object> getter : this.getters) {
            rawValues.add(getter.getRaw(this.getterTarget));
        }
        return rawValues;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Object>> getGetters() {
        return this.getters;
    }

    public @UnknownKeyFor @NonNull @Initialized Object getGetterTarget() {
        return this.getterTarget;
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof RowWithGetters) {
            RowWithGetters other = (RowWithGetters)o;
            return Objects.equals(this.getSchema(), other.getSchema()) && Objects.equals(this.getterTarget, other.getterTarget);
        }
        if (o instanceof Row) {
            return super.equals(o);
        }
        return false;
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getSchema(), this.getterTarget);
    }
}

