/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hop.base;

import org.apache.hop.core.listeners.IFilenameChangedListener;

import java.util.Objects;

public class MockFilenameChangeListener implements IFilenameChangedListener {

  private int id;

  public MockFilenameChangeListener(int id) {
    this.id = id;
  }

  @Override
  public void filenameChanged(Object object, String oldFilename, String newFilename) {
    // Nothing
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MockFilenameChangeListener that = (MockFilenameChangeListener) o;
    return id == that.id;
  }

  @Override
  public int hashCode() {
    return Objects.hash(id);
  }

  /**
   * Gets id
   *
   * @return value of id
   */
  public int getId() {
    return id;
  }

  /** @param id The id to set */
  public void setId(int id) {
    this.id = id;
  }
}
