/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.ssl;

import org.apache.hc.core5.http.ssl.TlsCiphers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestTlsCiphers {
    TestTlsCiphers() {
    }

    @Test
    void testStrongCipherSuites() {
        String[] strongCipherSuites;
        for (String cipherSuite : strongCipherSuites = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384"}) {
            Assertions.assertFalse((boolean)TlsCiphers.isWeak((String)cipherSuite));
        }
    }

    @Test
    void testWeakCiphersDisabledByDefault() {
        String[] weakCiphersSuites;
        for (String cipherSuite : weakCiphersSuites = new String[]{"SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DH_anon_WITH_AES_128_CBC_SHA", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_WITH_NULL_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_DH_anon_WITH_AES_256_GCM_SHA384", "TLS_ECDH_anon_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_NULL_SHA256", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "TLS_KRB5_EXPORT_WITH_RC4_40_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5"}) {
            Assertions.assertTrue((boolean)TlsCiphers.isWeak((String)cipherSuite));
        }
    }

    @Test
    void excludeH2Blacklisted() {
        String[] strongCipherSuites;
        String[] mixCipherSuites = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_RSA_WITH_AES_256_CBC_SHA256", "AES_SHA_US", "TLS_RSA_WITH_AES_128_CBC_SHA", "NULL_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384"};
        for (String cipherSuite : strongCipherSuites = TlsCiphers.excludeH2Blacklisted((String[])mixCipherSuites)) {
            Assertions.assertFalse((boolean)TlsCiphers.isWeak((String)cipherSuite));
        }
    }

    @Test
    void excludeWeak() {
        String[] strongCipherSuites;
        String[] weakCiphersSuites = new String[]{"SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DH_anon_WITH_AES_128_CBC_SHA", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_WITH_NULL_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_DH_anon_WITH_AES_256_GCM_SHA384", "TLS_ECDH_anon_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_NULL_SHA256", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "TLS_KRB5_EXPORT_WITH_RC4_40_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384"};
        for (String cipherSuite : strongCipherSuites = TlsCiphers.excludeWeak((String[])weakCiphersSuites)) {
            Assertions.assertFalse((boolean)TlsCiphers.isWeak((String)cipherSuite));
        }
    }

    @Test
    void excludeWeakNull() {
        Assertions.assertNull((Object)TlsCiphers.excludeWeak((String[])null));
    }
}

