/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.command;

import java.util.List;
import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.command.BuildIndexCommand;
import org.apache.ignite3.internal.partition.replicator.network.command.BuildIndexCommandBuilder;

class BuildIndexCommandDeserializer
implements MessageDeserializer<BuildIndexCommand> {
    private final BuildIndexCommandBuilder msg;

    BuildIndexCommandDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.buildIndexCommand();
    }

    @Override
    public Class<BuildIndexCommand> klass() {
        return BuildIndexCommand.class;
    }

    @Override
    public BuildIndexCommand getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readBoolean("finish");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.finish(tmp != 0);
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("indexId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.indexId(tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readList("rowIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.rowIds((List<UUID>)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(BuildIndexCommand.class);
    }
}

