/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.actions.DeleteReachableFiles;
import org.apache.iceberg.actions.ImmutableDeleteReachableFiles;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.SupportsBulkOperations;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.JobGroupInfo;
import org.apache.iceberg.spark.actions.BaseSparkAction;
import org.apache.iceberg.spark.actions.FileInfo;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteReachableFilesSparkAction
extends BaseSparkAction<DeleteReachableFilesSparkAction>
implements DeleteReachableFiles {
    public static final String STREAM_RESULTS = "stream-results";
    public static final boolean STREAM_RESULTS_DEFAULT = false;
    private static final Logger LOG = LoggerFactory.getLogger(DeleteReachableFilesSparkAction.class);
    private final String metadataFileLocation;
    private Consumer<String> deleteFunc = null;
    private ExecutorService deleteExecutorService = null;
    private FileIO io = new HadoopFileIO(this.spark().sessionState().newHadoopConf());

    DeleteReachableFilesSparkAction(SparkSession spark, String metadataFileLocation) {
        super(spark);
        this.metadataFileLocation = metadataFileLocation;
    }

    @Override
    protected DeleteReachableFilesSparkAction self() {
        return this;
    }

    public DeleteReachableFilesSparkAction io(FileIO fileIO) {
        this.io = fileIO;
        return this;
    }

    public DeleteReachableFilesSparkAction deleteWith(Consumer<String> newDeleteFunc) {
        this.deleteFunc = newDeleteFunc;
        return this;
    }

    public DeleteReachableFilesSparkAction executeDeleteWith(ExecutorService executorService) {
        this.deleteExecutorService = executorService;
        return this;
    }

    public DeleteReachableFiles.Result execute() {
        Preconditions.checkArgument((this.io != null ? 1 : 0) != 0, (Object)"File IO cannot be null");
        String jobDesc = String.format("Deleting files reachable from %s", this.metadataFileLocation);
        JobGroupInfo info = this.newJobGroupInfo("DELETE-REACHABLE-FILES", jobDesc);
        return this.withJobGroupInfo(info, this::doExecute);
    }

    private DeleteReachableFiles.Result doExecute() {
        TableMetadata metadata = TableMetadataParser.read((FileIO)this.io, (String)this.metadataFileLocation);
        ValidationException.check((boolean)PropertyUtil.propertyAsBoolean((Map)metadata.properties(), (String)"gc.enabled", (boolean)true), (String)"Cannot delete files: GC is disabled (deleting files may corrupt other tables)", (Object[])new Object[0]);
        Dataset<FileInfo> reachableFileDS = this.reachableFileDS(metadata);
        if (this.streamResults()) {
            return this.deleteFiles(reachableFileDS.toLocalIterator());
        }
        return this.deleteFiles(reachableFileDS.collectAsList().iterator());
    }

    private boolean streamResults() {
        return PropertyUtil.propertyAsBoolean(this.options(), (String)STREAM_RESULTS, (boolean)false);
    }

    private Dataset<FileInfo> reachableFileDS(TableMetadata metadata) {
        Table staticTable = this.newStaticTable(metadata, this.io);
        return this.contentFileDS(staticTable).union(this.manifestDS(staticTable)).union(this.manifestListDS(staticTable)).union(this.allReachableOtherMetadataFileDS(staticTable)).distinct();
    }

    private DeleteReachableFiles.Result deleteFiles(Iterator<FileInfo> files) {
        BaseSparkAction.DeleteSummary summary;
        if (this.deleteFunc == null && this.io instanceof SupportsBulkOperations) {
            summary = this.deleteFiles((SupportsBulkOperations)this.io, files);
        } else if (this.deleteFunc == null) {
            LOG.info("Table IO {} does not support bulk operations. Using non-bulk deletes.", (Object)this.io.getClass().getName());
            summary = this.deleteFiles(this.deleteExecutorService, arg_0 -> ((FileIO)this.io).deleteFile(arg_0), files);
        } else {
            LOG.info("Custom delete function provided. Using non-bulk deletes");
            summary = this.deleteFiles(this.deleteExecutorService, this.deleteFunc, files);
        }
        LOG.info("Deleted {} total files", (Object)summary.totalFilesCount());
        return ImmutableDeleteReachableFiles.Result.builder().deletedDataFilesCount(summary.dataFilesCount()).deletedPositionDeleteFilesCount(summary.positionDeleteFilesCount()).deletedEqualityDeleteFilesCount(summary.equalityDeleteFilesCount()).deletedManifestsCount(summary.manifestsCount()).deletedManifestListsCount(summary.manifestListsCount()).deletedOtherFilesCount(summary.otherFilesCount()).build();
    }
}

