/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.checkpoint.CheckpointStoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ZooKeeperCheckpointStoreUtil implements CheckpointStoreUtil
{
    INSTANCE;

    private static final Logger LOG;

    @Override
    public String checkpointIDToName(long checkpointId) {
        return String.format("/%019d", checkpointId);
    }

    @Override
    public long nameToCheckpointID(String path) {
        try {
            String numberString = '/' == path.charAt(0) ? path.substring(1) : path;
            return Long.parseLong(numberString);
        }
        catch (NumberFormatException e) {
            LOG.warn("Could not parse checkpoint id from {}. This indicates that the checkpoint id to path conversion has changed.", (Object)path);
            return -1L;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(ZooKeeperCheckpointStoreUtil.class);
    }
}

