/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.net;

import com.vesoft.nebula.client.graph.NebulaPoolConfig;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.exception.ClientServerIncompatibleException;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.LoadBalancer;
import com.vesoft.nebula.client.graph.net.SyncConnection;
import java.io.Serializable;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class ConnObjectPool
extends BasePooledObjectFactory<SyncConnection>
implements Serializable {
    private static final long serialVersionUID = 6101157301791971560L;
    private final NebulaPoolConfig config;
    private final LoadBalancer loadBalancer;
    private static final int retryTime = 3;

    public ConnObjectPool(LoadBalancer loadBalancer, NebulaPoolConfig config) {
        this.loadBalancer = loadBalancer;
        this.config = config;
    }

    public SyncConnection create() throws IOErrorException, ClientServerIncompatibleException {
        HostAddress address = this.loadBalancer.getAddress();
        if (address == null) {
            throw new IOErrorException(1, "All servers are broken.");
        }
        int retry = 3;
        SyncConnection conn = new SyncConnection();
        while (retry-- > 0) {
            try {
                if (this.config.isEnableSsl()) {
                    if (this.config.getSslParam() == null) {
                        throw new IllegalArgumentException("SSL Param is required when enableSsl is set to true");
                    }
                    conn.open(address, this.config.getTimeout(), this.config.getSslParam());
                } else {
                    conn.open(address, this.config.getTimeout());
                }
                return conn;
            }
            catch (IOErrorException e) {
                if (retry == 0) {
                    throw e;
                }
                this.loadBalancer.updateServersStatus();
            }
        }
        return null;
    }

    public PooledObject<SyncConnection> wrap(SyncConnection connection) {
        return new DefaultPooledObject((Object)connection);
    }

    public void destroyObject(PooledObject<SyncConnection> p) throws Exception {
        ((SyncConnection)p.getObject()).close();
        super.destroyObject(p);
    }

    public boolean validateObject(PooledObject<SyncConnection> p) {
        if (p.getObject() == null) {
            return false;
        }
        if (!((SyncConnection)p.getObject()).ping()) {
            ((SyncConnection)p.getObject()).close();
            return false;
        }
        return true;
    }

    public void activateObject(PooledObject<SyncConnection> p) throws Exception {
        if (p.getObject() == null) {
            throw new RuntimeException("The connection is null.");
        }
        if (!((SyncConnection)p.getObject()).ping()) {
            throw new RuntimeException("The connection is broken.");
        }
        super.activateObject(p);
    }

    public boolean init() {
        return this.loadBalancer.isServersOK();
    }

    public void updateServerStatus() {
        this.loadBalancer.updateServersStatus();
    }
}

