/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.manager.service.impl.AbstractImExportServiceImpl;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExcelImExportServiceImpl
extends AbstractImExportServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ExcelImExportServiceImpl.class);

    @Override
    public String type() {
        return "EXCEL";
    }

    @Override
    public String getFileName() {
        return this.fileNamePrefix() + ".xlsx";
    }

    @Override
    public List<AbstractImExportServiceImpl.ExportMonitorDTO> parseImport(InputStream is) {
        ArrayList<AbstractImExportServiceImpl.ExportMonitorDTO> arrayList;
        block12: {
            Workbook workbook = WorkbookFactory.create((InputStream)is);
            try {
                int i;
                Sheet sheet = workbook.getSheetAt(0);
                ArrayList<AbstractImExportServiceImpl.ExportMonitorDTO> monitors = new ArrayList<AbstractImExportServiceImpl.ExportMonitorDTO>();
                ArrayList<Integer> startRowList = new ArrayList<Integer>();
                for (Row row : sheet) {
                    String name;
                    if (row.getRowNum() == 0 || !StringUtils.isNotBlank((CharSequence)(name = this.getCellValueAsString(row.getCell(0))))) continue;
                    startRowList.add(row.getRowNum());
                    AbstractImExportServiceImpl.MonitorDTO monitor = this.extractMonitorDataFromRow(row);
                    AbstractImExportServiceImpl.ExportMonitorDTO exportMonitor = new AbstractImExportServiceImpl.ExportMonitorDTO();
                    exportMonitor.setMonitor(monitor);
                    monitors.add(exportMonitor);
                }
                ArrayList paramsList = new ArrayList();
                for (i = 0; i < startRowList.size(); ++i) {
                    int startRowIndex = (Integer)startRowList.get(i);
                    int endRowIndex = i + 1 < startRowList.size() ? (Integer)startRowList.get(i + 1) : sheet.getLastRowNum() + 1;
                    ArrayList<AbstractImExportServiceImpl.ParamDTO> params = new ArrayList<AbstractImExportServiceImpl.ParamDTO>();
                    for (int j = startRowIndex; j < endRowIndex; ++j) {
                        AbstractImExportServiceImpl.ParamDTO param;
                        Row row = sheet.getRow(j);
                        if (row == null || (param = this.extractParamDataFromRow(row)) == null) continue;
                        params.add(param);
                    }
                    paramsList.add(params);
                }
                for (i = 0; i < monitors.size(); ++i) {
                    ((AbstractImExportServiceImpl.ExportMonitorDTO)monitors.get(i)).setParams((List)paramsList.get(i));
                }
                arrayList = monitors;
                if (workbook == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to parse monitor data", e);
                }
            }
            workbook.close();
        }
        return arrayList;
    }

    private AbstractImExportServiceImpl.MonitorDTO extractMonitorDataFromRow(Row row) {
        AbstractImExportServiceImpl.MonitorDTO monitor = new AbstractImExportServiceImpl.MonitorDTO();
        monitor.setName(this.getCellValueAsString(row.getCell(0)));
        monitor.setApp(this.getCellValueAsString(row.getCell(1)));
        monitor.setHost(this.getCellValueAsString(row.getCell(2)));
        monitor.setIntervals(this.getCellValueAsInteger(row.getCell(3)));
        monitor.setStatus(this.getCellValueAsByte(row.getCell(4)));
        monitor.setDescription(this.getCellValueAsString(row.getCell(5)));
        String labelsString = this.getCellValueAsString(row.getCell(6));
        if (StringUtils.isNotBlank((CharSequence)labelsString)) {
            try {
                TypeReference<Map<String, String>> typeReference = new TypeReference<Map<String, String>>(){};
                Map<String, String> labels = JsonUtil.fromJson(labelsString, typeReference);
                monitor.setLabels(labels);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        monitor.setCollector(this.getCellValueAsString(row.getCell(7)));
        return monitor;
    }

    private AbstractImExportServiceImpl.ParamDTO extractParamDataFromRow(Row row) {
        String fieldName = this.getCellValueAsString(row.getCell(8));
        if (StringUtils.isNotBlank((CharSequence)fieldName)) {
            AbstractImExportServiceImpl.ParamDTO param = new AbstractImExportServiceImpl.ParamDTO();
            param.setField(fieldName);
            param.setType(this.getCellValueAsByte(row.getCell(9)));
            param.setValue(this.getCellValueAsString(row.getCell(10)));
            return param;
        }
        return null;
    }

    private String getCellValueAsString(Cell cell) {
        if (cell == null) {
            return null;
        }
        return switch (cell.getCellType()) {
            case CellType.STRING -> cell.getStringCellValue();
            case CellType.NUMERIC -> String.valueOf(cell.getNumericCellValue());
            default -> null;
        };
    }

    private boolean getCellValueAsBoolean(Cell cell) {
        if (cell == null) {
            return false;
        }
        if (Objects.requireNonNull(cell.getCellType()) == CellType.BOOLEAN) {
            return cell.getBooleanCellValue();
        }
        return false;
    }

    private Integer getCellValueAsInteger(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (Objects.requireNonNull(cell.getCellType()) == CellType.NUMERIC) {
            return (int)cell.getNumericCellValue();
        }
        return null;
    }

    private Byte getCellValueAsByte(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (Objects.requireNonNull(cell.getCellType()) == CellType.NUMERIC) {
            return (byte)cell.getNumericCellValue();
        }
        return null;
    }

    @Override
    public void writeOs(List<AbstractImExportServiceImpl.ExportMonitorDTO> monitorList, OutputStream os) {
        try {
            Workbook workbook = WorkbookFactory.create((boolean)true);
            String sheetName = "Export Monitor";
            Sheet sheet = workbook.createSheet(sheetName);
            sheet.setDefaultColumnWidth(20);
            sheet.setColumnWidth(6, 10240);
            sheet.setColumnWidth(10, 10240);
            CellStyle headerCellStyle = workbook.createCellStyle();
            Font headerFont = workbook.createFont();
            headerFont.setBold(true);
            headerCellStyle.setFont(headerFont);
            headerCellStyle.setAlignment(HorizontalAlignment.CENTER);
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            String[] headers = new String[]{"Name", "App", "Host", "Intervals", "Status", "Description", "Labels", "Collector", "Param-Field", "Param-Type", "Param-Value"};
            Row headerRow = sheet.createRow(0);
            for (int i = 0; i < headers.length; ++i) {
                Cell cell = headerRow.createCell(i);
                cell.setCellValue(headers[i]);
                cell.setCellStyle(headerCellStyle);
            }
            int rowIndex = 1;
            for (AbstractImExportServiceImpl.ExportMonitorDTO monitor : monitorList) {
                AbstractImExportServiceImpl.MonitorDTO monitorDTO = monitor.getMonitor();
                List<AbstractImExportServiceImpl.ParamDTO> paramList = monitor.getParams();
                for (int i = 0; i < Math.max(paramList.size(), 1); ++i) {
                    Row row = sheet.createRow(rowIndex++);
                    if (i == 0) {
                        Cell nameCell = row.createCell(0);
                        nameCell.setCellValue(monitorDTO.getName());
                        nameCell.setCellStyle(cellStyle);
                        Cell appCell = row.createCell(1);
                        appCell.setCellValue(monitorDTO.getApp());
                        appCell.setCellStyle(cellStyle);
                        Cell hostCell = row.createCell(2);
                        hostCell.setCellValue(monitorDTO.getHost());
                        hostCell.setCellStyle(cellStyle);
                        Cell intervalsCell = row.createCell(3);
                        intervalsCell.setCellValue((double)monitorDTO.getIntervals().intValue());
                        intervalsCell.setCellStyle(cellStyle);
                        Cell statusCell = row.createCell(4);
                        statusCell.setCellValue((double)monitorDTO.getStatus().byteValue());
                        statusCell.setCellStyle(cellStyle);
                        Cell descriptionCell = row.createCell(5);
                        descriptionCell.setCellValue(monitorDTO.getDescription());
                        descriptionCell.setCellStyle(cellStyle);
                        Cell labelsCell = row.createCell(6);
                        labelsCell.setCellValue(JsonUtil.toJson(monitorDTO.getLabels()));
                        labelsCell.setCellStyle(cellStyle);
                        Cell collectorCell = row.createCell(7);
                        collectorCell.setCellValue(monitorDTO.getCollector());
                        collectorCell.setCellStyle(cellStyle);
                    }
                    if (i >= paramList.size()) continue;
                    AbstractImExportServiceImpl.ParamDTO paramDTO = paramList.get(i);
                    Cell fieldCell = row.createCell(8);
                    fieldCell.setCellValue(paramDTO.getField());
                    fieldCell.setCellStyle(cellStyle);
                    Cell typeCell = row.createCell(9);
                    typeCell.setCellValue((double)paramDTO.getType().byteValue());
                    typeCell.setCellStyle(cellStyle);
                    Cell valueCell = row.createCell(10);
                    valueCell.setCellValue(paramDTO.getValue());
                    valueCell.setCellStyle(cellStyle);
                }
                if (!CollectionUtils.isNotEmpty(paramList)) continue;
                RegionUtil.setBorderTop((BorderStyle)BorderStyle.THICK, (CellRangeAddress)new CellRangeAddress(rowIndex - paramList.size(), rowIndex - 1, 0, 10), (Sheet)sheet);
                RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THICK, (CellRangeAddress)new CellRangeAddress(rowIndex - paramList.size(), rowIndex - 1, 0, 10), (Sheet)sheet);
                RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THICK, (CellRangeAddress)new CellRangeAddress(rowIndex - paramList.size(), rowIndex - 1, 0, 10), (Sheet)sheet);
                RegionUtil.setBorderRight((BorderStyle)BorderStyle.THICK, (CellRangeAddress)new CellRangeAddress(rowIndex - paramList.size(), rowIndex - 1, 0, 10), (Sheet)sheet);
            }
            workbook.write(os);
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

