/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.topic;

import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.protocol.body.ClusterInfo;
import org.apache.rocketmq.common.protocol.body.GroupList;
import org.apache.rocketmq.common.protocol.body.TopicList;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.common.protocol.route.TopicRouteData;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class TopicListSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "topicList";
    }

    @Override
    public String commandDesc() {
        return "Fetch all topic list from name server";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("c", "clusterModel", false, "clusterModel");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        block12: {
            DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
            defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
            try {
                defaultMQAdminExt.start();
                if (commandLine.hasOption('c')) {
                    ClusterInfo clusterInfo = defaultMQAdminExt.examineBrokerClusterInfo();
                    System.out.printf("%-20s  %-48s  %-48s%n", "#Cluster Name", "#Topic", "#Consumer Group");
                    TopicList topicList = defaultMQAdminExt.fetchAllTopicList();
                    for (String topic : topicList.getTopicList()) {
                        if (topic.startsWith("%RETRY%") || topic.startsWith("%DLQ%")) continue;
                        String clusterName = "";
                        GroupList groupList = new GroupList();
                        try {
                            clusterName = this.findTopicBelongToWhichCluster(topic, clusterInfo, defaultMQAdminExt);
                            groupList = defaultMQAdminExt.queryTopicConsumeByWho(topic);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (null == groupList || groupList.getGroupList().isEmpty()) {
                            groupList = new GroupList();
                            groupList.getGroupList().add("");
                        }
                        for (String group : groupList.getGroupList()) {
                            System.out.printf("%-20s  %-64s  %-64s%n", UtilAll.frontStringAtLeast((String)clusterName, (int)20), UtilAll.frontStringAtLeast((String)topic, (int)64), UtilAll.frontStringAtLeast((String)group, (int)64));
                        }
                    }
                    break block12;
                }
                TopicList topicList = defaultMQAdminExt.fetchAllTopicList();
                for (String topic : topicList.getTopicList()) {
                    System.out.printf("%s%n", topic);
                }
            }
            catch (Exception e) {
                throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
            }
            finally {
                defaultMQAdminExt.shutdown();
            }
        }
    }

    private String findTopicBelongToWhichCluster(String topic, ClusterInfo clusterInfo, DefaultMQAdminExt defaultMQAdminExt) throws RemotingException, MQClientException, InterruptedException {
        TopicRouteData topicRouteData = defaultMQAdminExt.examineTopicRouteInfo(topic);
        BrokerData brokerData = (BrokerData)topicRouteData.getBrokerDatas().get(0);
        String brokerName = brokerData.getBrokerName();
        for (Map.Entry next : clusterInfo.getClusterAddrTable().entrySet()) {
            if (!((Set)next.getValue()).contains(brokerName)) continue;
            return (String)next.getKey();
        }
        return null;
    }
}

