/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.polaris.core.catalog.PolarisCatalogHelpers;
import org.apache.polaris.core.entity.LocationBasedEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityType;

public class NamespaceEntity
extends PolarisEntity
implements LocationBasedEntity {
    public static final String PARENT_NAMESPACE_KEY = "parent-namespace";

    public NamespaceEntity(PolarisBaseEntity sourceEntity) {
        super(sourceEntity);
    }

    public static NamespaceEntity of(PolarisBaseEntity sourceEntity) {
        if (sourceEntity != null) {
            return new NamespaceEntity(sourceEntity);
        }
        return null;
    }

    public Namespace getParentNamespace() {
        String encodedNamespace = this.getInternalPropertiesAsMap().get(PARENT_NAMESPACE_KEY);
        if (encodedNamespace == null) {
            return Namespace.empty();
        }
        return RESTUtil.decodeNamespace((String)encodedNamespace);
    }

    public Namespace asNamespace() {
        Namespace parent = this.getParentNamespace();
        String[] levels = new String[parent.length() + 1];
        for (int i = 0; i < parent.length(); ++i) {
            levels[i] = parent.level(i);
        }
        levels[levels.length - 1] = this.getName();
        return Namespace.of((String[])levels);
    }

    @Override
    @JsonIgnore
    public String getBaseLocation() {
        return this.getPropertiesAsMap().get("location");
    }

    public static class Builder
    extends PolarisEntity.BaseBuilder<NamespaceEntity, Builder> {
        public Builder(Namespace namespace) {
            this.setType(PolarisEntityType.NAMESPACE);
            this.setParentNamespace(PolarisCatalogHelpers.getParentNamespace(namespace));
            this.setName(namespace.level(namespace.length() - 1));
        }

        public Builder setBaseLocation(String baseLocation) {
            this.properties.put("location", baseLocation);
            return this;
        }

        public Builder setParentNamespace(Namespace namespace) {
            if (namespace != null && !namespace.isEmpty()) {
                this.internalProperties.put(NamespaceEntity.PARENT_NAMESPACE_KEY, RESTUtil.encodeNamespace((Namespace)namespace));
            }
            return this;
        }

        @Override
        public NamespaceEntity build() {
            return new NamespaceEntity(this.buildBase());
        }
    }
}

