/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.execute.lock;

import org.apache.seata.server.cluster.raft.execute.AbstractRaftMsgExecute;
import org.apache.seata.server.cluster.raft.sync.msg.RaftBaseMsg;
import org.apache.seata.server.cluster.raft.sync.msg.RaftBranchSessionSyncMsg;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionHolder;

public class BranchReleaseLockExecute
extends AbstractRaftMsgExecute {
    public Boolean execute(RaftBaseMsg syncMsg) throws Throwable {
        RaftBranchSessionSyncMsg sessionSyncMsg = (RaftBranchSessionSyncMsg)syncMsg;
        String xid = sessionSyncMsg.getBranchSession().getXid();
        GlobalSession globalSession = SessionHolder.getRootSessionManager().findGlobalSession(xid);
        if (globalSession == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("The transaction corresponding to the XID: {} does not exist, which may cause a two-phase concurrency issue, msg type: {}", (Object)xid, (Object)syncMsg.getMsgType());
            }
            return false;
        }
        BranchSession branchSession = globalSession.getBranch(sessionSyncMsg.getBranchSession().getBranchId().longValue());
        if (branchSession != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("releaseBranchSessionLock xid: {}", (Object)globalSession.getXid());
            }
            return this.raftLockManager.localReleaseLock(branchSession);
        }
        return false;
    }
}

