/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.PluginException;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.InstanceMethodsAroundInterceptorV2;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.MethodInvocationContext;
import org.apache.skywalking.apm.agent.core.plugin.loader.InterceptorInstanceLoader;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.AllArguments;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.Origin;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.SuperCall;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.This;

public class InstMethodsInterV2 {
    private static final ILog LOGGER = LogManager.getLogger(InstMethodsInterV2.class);
    private InstanceMethodsAroundInterceptorV2 interceptor;

    public InstMethodsInterV2(String instanceMethodsAroundInterceptorClassName, ClassLoader classLoader) {
        try {
            this.interceptor = (InstanceMethodsAroundInterceptorV2)InterceptorInstanceLoader.load(instanceMethodsAroundInterceptorClassName, classLoader);
        }
        catch (Throwable t) {
            throw new PluginException("Can't create InstanceMethodsAroundInterceptor.", t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RuntimeType
    public Object intercept(@This Object obj, @AllArguments Object[] allArguments, @SuperCall Callable<?> zuper, @Origin Method method) throws Throwable {
        EnhancedInstance targetObject = (EnhancedInstance)obj;
        MethodInvocationContext context = new MethodInvocationContext();
        try {
            this.interceptor.beforeMethod(targetObject, method, allArguments, method.getParameterTypes(), context);
        }
        catch (Throwable t) {
            LOGGER.error(t, "class[{}] before method[{}] intercept failure", obj.getClass(), method.getName());
        }
        Object ret = null;
        try {
            ret = !context.isContinue() ? context._ret() : zuper.call();
        }
        catch (Throwable t) {
            try {
                try {
                    this.interceptor.handleMethodException(targetObject, method, allArguments, method.getParameterTypes(), t, context);
                    throw t;
                }
                catch (Throwable t2) {
                    LOGGER.error(t2, "class[{}] handle method[{}] exception failure", obj.getClass(), method.getName());
                }
                throw t;
            }
            catch (Throwable throwable) {
                try {
                    ret = this.interceptor.afterMethod(targetObject, method, allArguments, method.getParameterTypes(), ret, context);
                    throw throwable;
                }
                catch (Throwable t2) {
                    LOGGER.error(t2, "class[{}] after method[{}] intercept failure", obj.getClass(), method.getName());
                }
                throw throwable;
            }
        }
        try {
            return this.interceptor.afterMethod(targetObject, method, allArguments, method.getParameterTypes(), ret, context);
        }
        catch (Throwable t) {
            LOGGER.error(t, "class[{}] after method[{}] intercept failure", obj.getClass(), method.getName());
            return ret;
        }
    }
}

