/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.infix.lang.infix.antlr;

import com.google.common.base.Predicate;
import com.netflix.infix.NumericValuePredicate;
import com.netflix.infix.PathValueEventFilter;
import com.netflix.infix.TimeMillisValuePredicate;
import com.netflix.infix.TimeStringValuePredicate;
import com.netflix.infix.lang.infix.antlr.PredicateBaseTreeNode;
import com.netflix.infix.lang.infix.antlr.PredicateTranslatable;
import com.netflix.infix.lang.infix.antlr.TimeMillisValueTreeNode;
import com.netflix.infix.lang.infix.antlr.TimeStringValueTreeNode;
import com.netflix.infix.lang.infix.antlr.TreeNodeUtil;
import com.netflix.infix.lang.infix.antlr.UnexpectedTokenException;
import com.netflix.infix.lang.infix.antlr.ValueTreeNode;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.Tree;

public class ComparableTreeNode
extends PredicateBaseTreeNode
implements PredicateTranslatable {
    @Override
    public Predicate<Object> translate() {
        String xpath = TreeNodeUtil.getXPath(this.getChild(0));
        Tree valueNode = this.getChild(1);
        switch (valueNode.getType()) {
            case 23: {
                Number value = (Number)((ValueTreeNode)valueNode).getValue();
                return new PathValueEventFilter<Object>(xpath, new NumericValuePredicate(value, this.getToken().getText()));
            }
            case 27: {
                TimeMillisValueTreeNode timeValueNode = (TimeMillisValueTreeNode)valueNode;
                return new PathValueEventFilter<Object>(xpath, new TimeMillisValuePredicate(timeValueNode.getValueFormat(), timeValueNode.getValue(), this.getToken().getText()));
            }
            case 28: {
                TimeStringValueTreeNode timeStringNode = (TimeStringValueTreeNode)valueNode;
                return new PathValueEventFilter<Object>(xpath, new TimeStringValuePredicate(timeStringNode.getValueTimeFormat(), timeStringNode.getInputTimeFormat(), timeStringNode.getValue(), this.getToken().getText()));
            }
        }
        throw new UnexpectedTokenException(valueNode, "Number", "time-millis", "time-string");
    }

    public ComparableTreeNode(Token t) {
        super(t);
    }

    public ComparableTreeNode(ComparableTreeNode node) {
        super(node);
    }

    public Tree dupNode() {
        return new ComparableTreeNode(this);
    }
}

