/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.foundation.internals.provider;

import com.ctrip.framework.apollo.core.utils.DeferredLoggerFactory;
import com.ctrip.framework.apollo.core.utils.DeprecatedPropertyNotifyUtil;
import com.ctrip.framework.foundation.internals.Utils;
import com.ctrip.framework.foundation.internals.io.BOMInputStream;
import com.ctrip.framework.foundation.spi.provider.ApplicationProvider;
import com.ctrip.framework.foundation.spi.provider.Provider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.slf4j.Logger;

public class DefaultApplicationProvider
implements ApplicationProvider {
    private static final Logger logger = DeferredLoggerFactory.getLogger(DefaultApplicationProvider.class);
    public static final String APP_PROPERTIES_CLASSPATH = "/META-INF/app.properties";
    private Properties m_appProperties = new Properties();
    private String m_appId;
    private String m_appLabel;
    private String accessKeySecret;

    @Override
    public void initialize() {
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(APP_PROPERTIES_CLASSPATH.substring(1));
            if (in == null) {
                in = DefaultApplicationProvider.class.getResourceAsStream(APP_PROPERTIES_CLASSPATH);
            }
            this.initialize(in);
        }
        catch (Throwable ex) {
            logger.error("Initialize DefaultApplicationProvider failed.", ex);
        }
    }

    @Override
    public void initialize(InputStream in) {
        try {
            if (in != null) {
                try {
                    this.m_appProperties.load(new InputStreamReader((InputStream)new BOMInputStream(in), StandardCharsets.UTF_8));
                }
                finally {
                    in.close();
                }
            }
            this.initAppId();
            this.initAppLabel();
            this.initAccessKey();
        }
        catch (Throwable ex) {
            logger.error("Initialize DefaultApplicationProvider failed.", ex);
        }
    }

    @Override
    public String getAppId() {
        return this.m_appId;
    }

    @Override
    public String getApolloLabel() {
        return this.m_appLabel;
    }

    @Override
    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    @Override
    public boolean isAppIdSet() {
        return !Utils.isBlank(this.m_appId);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        if ("app.id".equals(name)) {
            String val = this.getAppId();
            return val == null ? defaultValue : val;
        }
        if ("apollo.access-key.secret".equals(name)) {
            String val = this.getAccessKeySecret();
            return val == null ? defaultValue : val;
        }
        String val = this.m_appProperties.getProperty(name, defaultValue);
        return val == null ? defaultValue : val;
    }

    @Override
    public Class<? extends Provider> getType() {
        return ApplicationProvider.class;
    }

    private void initAppId() {
        this.m_appId = System.getProperty("app.id");
        if (!Utils.isBlank(this.m_appId)) {
            this.m_appId = this.m_appId.trim();
            logger.info("App ID is set to {} by app.id property from System Property", (Object)this.m_appId);
            return;
        }
        this.m_appId = System.getenv("APP_ID");
        if (!Utils.isBlank(this.m_appId)) {
            this.m_appId = this.m_appId.trim();
            logger.info("App ID is set to {} by APP_ID property from OS environment variable", (Object)this.m_appId);
            return;
        }
        this.m_appId = this.m_appProperties.getProperty("app.id");
        if (!Utils.isBlank(this.m_appId)) {
            this.m_appId = this.m_appId.trim();
            logger.info("App ID is set to {} by app.id property from {}", (Object)this.m_appId, (Object)APP_PROPERTIES_CLASSPATH);
            return;
        }
        this.m_appId = null;
        logger.warn("app.id is not available from System Property and {}. It is set to null", (Object)APP_PROPERTIES_CLASSPATH);
    }

    private void initAppLabel() {
        this.m_appLabel = System.getProperty("apollo.label");
        if (!Utils.isBlank(this.m_appLabel)) {
            this.m_appLabel = this.m_appLabel.trim();
            logger.info("App Label is set to {} by app.label property from System Property", (Object)this.m_appLabel);
            return;
        }
        this.m_appLabel = System.getenv("APOLLO_LABEL");
        if (!Utils.isBlank(this.m_appLabel)) {
            this.m_appLabel = this.m_appLabel.trim();
            logger.info("App Label is set to {} by APP_LABEL property from OS environment variable", (Object)this.m_appLabel);
            return;
        }
        this.m_appLabel = this.m_appProperties.getProperty("apollo.label");
        if (!Utils.isBlank(this.m_appLabel)) {
            this.m_appLabel = this.m_appLabel.trim();
            logger.info("App Label is set to {} by app.label property from {}", (Object)this.m_appLabel, (Object)APP_PROPERTIES_CLASSPATH);
            return;
        }
        this.m_appLabel = null;
        logger.warn("app.label is not available from System Property and {}. It is set to null", (Object)APP_PROPERTIES_CLASSPATH);
    }

    private void initAccessKey() {
        this.accessKeySecret = System.getProperty("apollo.access-key.secret");
        if (!Utils.isBlank(this.accessKeySecret)) {
            this.accessKeySecret = this.accessKeySecret.trim();
            logger.info("ACCESS KEY SECRET is set by apollo.access-key.secret property from System Property");
            return;
        }
        this.accessKeySecret = System.getenv("APOLLO_ACCESS_KEY_SECRET");
        if (!Utils.isBlank(this.accessKeySecret)) {
            this.accessKeySecret = this.accessKeySecret.trim();
            logger.info("ACCESS KEY SECRET is set by APOLLO_ACCESS_KEY_SECRET property from OS environment variable");
            return;
        }
        this.accessKeySecret = this.m_appProperties.getProperty("apollo.access-key.secret");
        if (!Utils.isBlank(this.accessKeySecret)) {
            this.accessKeySecret = this.accessKeySecret.trim();
            logger.info("ACCESS KEY SECRET is set by apollo.access-key.secret property from {}", (Object)APP_PROPERTIES_CLASSPATH);
            return;
        }
        this.accessKeySecret = this.initDeprecatedAccessKey();
        if (!Utils.isBlank(this.accessKeySecret)) {
            return;
        }
        this.accessKeySecret = null;
    }

    private String initDeprecatedAccessKey() {
        String accessKeySecret = System.getProperty("apollo.accesskey.secret");
        if (!Utils.isBlank(accessKeySecret)) {
            accessKeySecret = accessKeySecret.trim();
            logger.info("ACCESS KEY SECRET is set by apollo.accesskey.secret property from System Property");
            DeprecatedPropertyNotifyUtil.warn("apollo.accesskey.secret", "apollo.access-key.secret");
            return accessKeySecret;
        }
        accessKeySecret = System.getenv("APOLLO_ACCESSKEY_SECRET");
        if (!Utils.isBlank(accessKeySecret)) {
            accessKeySecret = accessKeySecret.trim();
            logger.info("ACCESS KEY SECRET is set by APOLLO_ACCESSKEY_SECRET property from OS environment variable");
            DeprecatedPropertyNotifyUtil.warn("APOLLO_ACCESSKEY_SECRET", "APOLLO_ACCESS_KEY_SECRET");
            return accessKeySecret;
        }
        accessKeySecret = this.m_appProperties.getProperty("apollo.accesskey.secret");
        if (!Utils.isBlank(accessKeySecret)) {
            accessKeySecret = accessKeySecret.trim();
            logger.info("ACCESS KEY SECRET is set by apollo.accesskey.secret property from {}", (Object)APP_PROPERTIES_CLASSPATH);
            DeprecatedPropertyNotifyUtil.warn("apollo.accesskey.secret", "apollo.access-key.secret");
            return accessKeySecret;
        }
        return null;
    }

    public String toString() {
        return "appId [" + this.getAppId() + "] properties: " + this.m_appProperties + " (DefaultApplicationProvider)";
    }
}

