/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.offset.offsetfile;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.utils.ConcurrentHashSet;
import org.apache.inlong.tubemq.server.broker.offset.OffsetStorageInfo;
import org.apache.inlong.tubemq.server.broker.offset.offsetfile.OffsetStgInfo;
import org.apache.inlong.tubemq.server.broker.offset.offsetfile.PartStgInfo;

public class GroupOffsetStgInfo {
    private final AtomicLong lstStoreTime = new AtomicLong(0L);
    private final int brokerId;
    private final ConcurrentHashMap<String, OffsetStgInfo> groupOffsetStgInfo = new ConcurrentHashMap();

    public GroupOffsetStgInfo(int brokerId) {
        this.brokerId = brokerId;
    }

    public boolean isStgInfoEmpty() {
        return this.groupOffsetStgInfo.isEmpty();
    }

    public boolean storeOffsetStgInfo(String group, Collection<OffsetStorageInfo> offsetInfoList, ConcurrentHashMap<String, ConcurrentHashSet<String>> groupTopicsInfo) {
        OffsetStgInfo tmpOffsetStgInfo;
        OffsetStgInfo curOffsetStgInfo = this.groupOffsetStgInfo.get(group);
        if (curOffsetStgInfo == null && (curOffsetStgInfo = this.groupOffsetStgInfo.putIfAbsent(group, tmpOffsetStgInfo = new OffsetStgInfo())) == null) {
            curOffsetStgInfo = tmpOffsetStgInfo;
        }
        boolean updated = false;
        for (OffsetStorageInfo info : offsetInfoList) {
            if (info == null || !info.isModified()) continue;
            if (curOffsetStgInfo.updOffsetInfo(info)) {
                ConcurrentHashSet tmpSet;
                ConcurrentHashSet topicSet = groupTopicsInfo.get(group);
                if (topicSet == null && (topicSet = groupTopicsInfo.putIfAbsent(group, (ConcurrentHashSet<String>)(tmpSet = new ConcurrentHashSet()))) == null) {
                    topicSet = tmpSet;
                }
                topicSet.add((Object)info.getTopic());
            }
            updated = true;
            info.setModified(false);
        }
        return updated;
    }

    public boolean addOffsetStgInfo(String group, String topic, int partId, long offset, long msgId) {
        OffsetStgInfo tmpOffsetStgInfo;
        OffsetStgInfo curOffsetStgInfo = this.groupOffsetStgInfo.get(group);
        if (curOffsetStgInfo == null && (curOffsetStgInfo = this.groupOffsetStgInfo.putIfAbsent(group, tmpOffsetStgInfo = new OffsetStgInfo())) == null) {
            curOffsetStgInfo = tmpOffsetStgInfo;
        }
        return curOffsetStgInfo.updOffsetInfo(topic, partId, 0L, msgId, offset, System.currentTimeMillis());
    }

    public Map<Integer, Long> queryGroupOffsetInfo(String group, String topic, Set<Integer> partIds) {
        OffsetStgInfo offsetStgInfo = this.groupOffsetStgInfo.get(group);
        if (offsetStgInfo == null) {
            HashMap<Integer, Long> offsetMap = new HashMap<Integer, Long>(partIds.size());
            for (Integer partId : partIds) {
                offsetMap.put(partId, null);
            }
            return offsetMap;
        }
        return offsetStgInfo.getPartOffsetInfo(topic, partIds);
    }

    public boolean rmvGroupOffsetInfo(String group, Map<String, Set<Integer>> topicParts) {
        OffsetStgInfo offsetStgInfo = this.groupOffsetStgInfo.get(group);
        if (offsetStgInfo == null) {
            return false;
        }
        for (Map.Entry<String, Set<Integer>> entry : topicParts.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty()) continue;
            offsetStgInfo.rmvPartOffsetInfo(entry.getKey(), entry.getValue());
        }
        if (offsetStgInfo.isOffsetStgInfoEmpty()) {
            this.groupOffsetStgInfo.remove(group);
        }
        return true;
    }

    public void rmvGroupOffsetInfo(String group, Set<String> rmvTopics) {
        OffsetStgInfo offsetStgInfo = this.groupOffsetStgInfo.get(group);
        if (offsetStgInfo == null) {
            return;
        }
        if (offsetStgInfo.rmvPartOffsetInfo(rmvTopics)) {
            this.groupOffsetStgInfo.remove(group);
        }
    }

    public ConcurrentHashMap<String, OffsetStgInfo> getGroupOffsetStgInfo() {
        return this.groupOffsetStgInfo;
    }

    public boolean includedTopic(String group, String topic) {
        OffsetStgInfo offsetStgInfo = this.groupOffsetStgInfo.get(group);
        if (offsetStgInfo == null) {
            return false;
        }
        return offsetStgInfo.includedTopic(topic);
    }

    public Map<String, PartStgInfo> getOffsetStgInfos(String group) {
        OffsetStgInfo offsetStgInfo = this.groupOffsetStgInfo.get(group);
        if (offsetStgInfo == null) {
            return null;
        }
        return offsetStgInfo.getPartOffsetInfo();
    }

    public PartStgInfo getOffsetStgInfo(String group, String topic, int partId) {
        OffsetStgInfo offsetStgInfo = this.groupOffsetStgInfo.get(group);
        if (offsetStgInfo == null) {
            return null;
        }
        return offsetStgInfo.getPartOffsetInfo(topic, partId);
    }

    public Set<String> rmvExpiredGroupOffsetInfo(long chkTime, long expireDurMs) {
        HashSet<String> rmvGroups = new HashSet<String>();
        for (Map.Entry<String, OffsetStgInfo> entry : this.groupOffsetStgInfo.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null || chkTime - entry.getValue().getLstCommitTime() <= expireDurMs) continue;
            rmvGroups.add(entry.getKey());
        }
        if (!rmvGroups.isEmpty()) {
            for (String group : rmvGroups) {
                if (group == null) continue;
                this.groupOffsetStgInfo.remove(group);
            }
        }
        return rmvGroups;
    }

    public void setLstStoreTime() {
        this.lstStoreTime.set(System.currentTimeMillis());
    }

    public void clear() {
        this.groupOffsetStgInfo.clear();
    }

    public String toString() {
        return "GroupOffsetStgInfo{lstStoreTime=" + this.lstStoreTime + ", brokerId=" + this.brokerId + ", groupOffsetStgInfo=" + this.groupOffsetStgInfo + '}';
    }
}

