/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.operationlog;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.OperationTarget;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.util.NetworkUtils;
import org.apache.inlong.manager.dao.entity.OperationLogEntity;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.service.operationlog.OperationLog;
import org.apache.inlong.manager.service.operationlog.OperationLogPool;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class OperationLogRecorder {
    private static final Logger log = LoggerFactory.getLogger(OperationLogRecorder.class);
    private static final String ANONYMOUS_USER = "AnonymousUser";
    private static final String INLONG_GROUP_ID = "inlongGroupId";
    private static final String INLONG_STREAM_ID = "inlongStreamId";
    private static final Gson GSON = new GsonBuilder().create();

    public static Object doAround(ProceedingJoinPoint joinPoint, OperationLog operationLog) throws Throwable {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return joinPoint.proceed();
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        UserInfo userInfo = Optional.ofNullable(LoginUserUtils.getLoginUser()).orElseGet(UserInfo::new);
        String operator = userInfo.getName();
        operator = StringUtils.isBlank((CharSequence)operator) ? ANONYMOUS_USER : operator;
        String requestUrl = request.getRequestURI();
        String httpMethod = request.getMethod();
        String remoteAddress = NetworkUtils.getClientIpAddress((HttpServletRequest)request);
        Object[] args = joinPoint.getArgs();
        String groupId = "";
        String streamId = "";
        for (Object arg : args) {
            try {
                JSONObject obj = (JSONObject)JSON.toJSON((Object)arg);
                for (Object key : obj.keySet()) {
                    if (Objects.equals(key, INLONG_GROUP_ID)) {
                        groupId = obj.getString((String)key);
                    }
                    if (!Objects.equals(key, INLONG_STREAM_ID)) continue;
                    streamId = obj.getString((String)key);
                }
            }
            catch (Exception ignored) {
                log.debug("do nothing when exception");
            }
        }
        String param = GSON.toJson((Object)request.getParameterMap());
        String body = GSON.toJson((Object)joinPoint.getArgs());
        long start = System.currentTimeMillis();
        boolean success = true;
        String errMsg = "";
        try {
            Object key;
            key = joinPoint.proceed();
            return key;
        }
        catch (Throwable throwable) {
            success = false;
            errMsg = throwable.getMessage();
            throw throwable;
        }
        finally {
            long costTime = System.currentTimeMillis() - start;
            OperationType operationType = operationLog.operation();
            OperationTarget operationTarget = operationLog.operationTarget();
            OperationLogEntity operationLogEntity = new OperationLogEntity();
            operationLogEntity.setInlongGroupId(groupId);
            operationLogEntity.setInlongStreamId(streamId);
            operationLogEntity.setOperationTarget(operationTarget.name());
            operationLogEntity.setOperationType(operationType.name());
            operationLogEntity.setHttpMethod(httpMethod);
            operationLogEntity.setOperator(operator);
            operationLogEntity.setRequestUrl(requestUrl);
            operationLogEntity.setRemoteAddress(remoteAddress);
            operationLogEntity.setCostTime(Long.valueOf(costTime));
            operationLogEntity.setBody(body);
            operationLogEntity.setParam(param);
            operationLogEntity.setStatus(Boolean.valueOf(success));
            operationLogEntity.setRequestTime(new Date());
            operationLogEntity.setErrMsg(errMsg);
            if (operationLog.db()) {
                OperationLogPool.publish(operationLogEntity);
            } else if (success) {
                log.info("operation log: {}", (Object)GSON.toJson((Object)operationLogEntity));
            } else {
                log.error("request handle failed : {}", (Object)GSON.toJson((Object)operationLogEntity));
            }
        }
    }
}

