/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.utils;

import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.inlong.sdk.dataproxy.common.ErrorCode;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.utils.LogCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static final LogCounter exceptCnt = new LogCounter(10L, 200000L, 60000L);

    public static boolean constructHttpClient(boolean rptByHttps, int socketTimeoutMs, int conTimeoutMs, String tlsVer, ProcessResult procResult) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(socketTimeoutMs).setConnectTimeout(conTimeoutMs).build();
        try {
            CloseableHttpClient httpClient;
            if (rptByHttps) {
                SSLContext sslContext = SSLContexts.custom().build();
                SSLConnectionSocketFactory sslSf = new SSLConnectionSocketFactory(sslContext, new String[]{tlsVer}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
                httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)sslSf).build();
            } else {
                httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
            }
            return procResult.setSuccess(httpClient);
        }
        catch (Throwable ex) {
            if (exceptCnt.shouldPrint()) {
                logger.error("Build http client exception", ex);
            }
            return procResult.setFailResult(ErrorCode.HTTP_BUILD_CLIENT_EXCEPTION, ex.getMessage());
        }
    }
}

