/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import net.sf.jsqlparser.expression.Function;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.parser.ColumnParser;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.apache.inlong.sdk.transform.process.pojo.FunctionInfo;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionTools {
    private static final Logger log = LoggerFactory.getLogger(FunctionTools.class);
    private static final String FUNCTION_PATH = "org.apache.inlong.sdk.transform.process.function";
    private static final Map<String, Class<?>> functionMap = Maps.newConcurrentMap();

    private static void init() {
        Reflections reflections = new Reflections(FUNCTION_PATH, new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()});
        Set clazzSet = reflections.getTypesAnnotatedWith(TransformFunction.class);
        for (Class clazz : clazzSet) {
            String[] functionNames;
            TransformFunction annotation = clazz.getAnnotation(TransformFunction.class);
            if (annotation == null || ArrayUtils.isEmpty((Object[])annotation.names())) continue;
            for (String functionName : functionNames = annotation.names()) {
                if (StringUtils.isEmpty((String)functionName)) continue;
                functionMap.compute(functionName, (name, former) -> {
                    if (former != null) {
                        log.warn("find a conflict function named [{}], the former one is [{}], new one is [{}]", new Object[]{name, former.getName(), clazz.getName()});
                    }
                    return clazz;
                });
            }
        }
    }

    public static Map<String, Set<FunctionInfo>> getFunctionDoc() {
        return FunctionDocHolder.functionDocMap;
    }

    public static ValueParser getTransformFunction(Function func) {
        if (func == null) {
            return null;
        }
        String functionName = func.getName().toLowerCase();
        Class<?> clazz = functionMap.get(functionName);
        if (clazz == null) {
            return new ColumnParser(func);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(func.getClass());
            return (ValueParser)constructor.newInstance(func);
        }
        catch (NoSuchMethodException e) {
            log.error("transform function {} needs one constructor that accept one params whose type is {}", new Object[]{clazz.getName(), func.getClass().getName(), e});
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        FunctionTools.init();
    }

    private static class FunctionDocHolder {
        private static final Map<String, Set<FunctionInfo>> functionDocMap = new ConcurrentSkipListMap<String, Set<FunctionInfo>>();

        private FunctionDocHolder() {
        }

        private static void initFunctionDoc() {
            Collection clazzList = functionMap.values();
            for (Class clazz : clazzList) {
                TransformFunction annotation = clazz.getAnnotation(TransformFunction.class);
                if (annotation == null || ArrayUtils.isEmpty((Object[])annotation.names())) continue;
                String type = annotation.type();
                FunctionInfo functionInfo = FunctionDocHolder.getFunctionInfo(annotation);
                functionDocMap.computeIfAbsent(type, k -> new ConcurrentSkipListSet<FunctionInfo>(Comparator.comparing(FunctionInfo::getFunctionName))).add(functionInfo);
            }
        }

        private static FunctionInfo getFunctionInfo(TransformFunction annotation) {
            StringBuilder name = new StringBuilder();
            StringBuilder explanation = new StringBuilder();
            StringBuilder example = new StringBuilder();
            for (String functionName : annotation.names()) {
                name.append(functionName.concat(annotation.parameter() + "\r\n"));
            }
            for (String functionExplanation : annotation.descriptions()) {
                explanation.append(functionExplanation.concat("\r\n"));
            }
            for (String functionExample : annotation.examples()) {
                example.append(functionExample.concat("\r\n"));
            }
            return new FunctionInfo(name.toString(), explanation.toString(), example.toString());
        }

        static {
            FunctionDocHolder.initFunctionDoc();
        }
    }
}

