/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"least"}, parameter="(Numeric value1 [, Numeric value2, ...])", descriptions={"- Return \"\" if any parameter is NULL;", "- Return the least value of the list of arguments."}, examples={"least(3.14, least(7, 2, 1)) = 1"})
public class LeastFunction
implements ValueParser {
    private List<ValueParser> parserList;

    public LeastFunction(Function expr) {
        if (expr.getParameters() == null) {
            this.parserList = new ArrayList<ValueParser>();
        } else {
            List params = expr.getParameters().getExpressions();
            this.parserList = new ArrayList<ValueParser>(params.size());
            for (Expression param : params) {
                ValueParser node = OperatorTools.buildParser(param);
                this.parserList.add(node);
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        BigDecimal minValue = null;
        for (ValueParser valueParser : this.parserList) {
            Object valueObj = valueParser.parse(sourceData, rowIndex, context);
            if (valueObj == null) {
                return null;
            }
            BigDecimal value = OperatorTools.parseBigDecimal(valueObj);
            if (minValue != null && value.compareTo(minValue) >= 0) continue;
            minValue = value;
        }
        return minValue;
    }
}

