/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.utils.file;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.inlong.agent.utils.file.DirNameRegexMatchPredicate;
import org.apache.inlong.agent.utils.file.FileFinderIterator;
import org.apache.inlong.agent.utils.file.FileNameRegexMatchPredicate;

public class FileFinder
implements Iterable<File> {
    private static final Predicate<File> isFile = new Predicate<File>(){

        public boolean apply(File input) {
            return input.isFile();
        }
    };
    private static final Predicate<File> isDirectory = new Predicate<File>(){

        public boolean apply(File input) {
            return input.isDirectory();
        }
    };
    private final File baseDir;
    private Predicate<File> yieldFilter = isFile;
    private Predicate<File> branchFilter = Predicates.alwaysFalse();
    private Predicate<File> fileFilter = Predicates.alwaysTrue();
    private Predicate<File> dirFilter = Predicates.alwaysTrue();
    private boolean caseSensitive = true;
    private int maxDepth = 1;

    public FileFinder(File baseDir) {
        this.baseDir = baseDir;
    }

    public FileFinder withDepth(int depth) {
        this.maxDepth = depth;
        return this;
    }

    public List<File> list() {
        return Lists.newArrayList(this.iterator());
    }

    @Override
    public Iterator<File> iterator() {
        return new FileFinderIterator(this.baseDir, this.yieldFilter, this.branchFilter, this.fileFilter, this.dirFilter, this.maxDepth);
    }

    public FileFinder yieldFiles() {
        this.yieldFilter = isFile;
        return this;
    }

    public FileFinder yieldDirectories() {
        this.yieldFilter = isDirectory;
        return this;
    }

    public FileFinder yieldFilesAndDirectories() {
        this.yieldFilter = Predicates.or(isFile, isDirectory);
        return this;
    }

    public FileFinder caseSensitive() {
        this.caseSensitive = true;
        return this;
    }

    public FileFinder ignoreCase() {
        this.caseSensitive = false;
        return this;
    }

    public FileFinder withFileNameRegex(String name) {
        return this.withFileFilter(new FileNameRegexMatchPredicate(name, this.caseSensitive));
    }

    public FileFinder withDirNameRegex(String name) {
        return this.withDirFilter(new DirNameRegexMatchPredicate(name, this.caseSensitive));
    }

    public FileFinder recursive() {
        this.branchFilter = Predicates.alwaysTrue();
        return this;
    }

    public FileFinder recursive(Predicate<File> branchFilter) {
        this.branchFilter = branchFilter;
        return this;
    }

    public FileFinder withFileFilter(Predicate<File> filter) {
        this.fileFilter = Predicates.and(this.fileFilter, filter);
        return this;
    }

    public FileFinder withDirFilter(Predicate<File> filter) {
        this.dirFilter = Predicates.and(this.dirFilter, filter);
        return this;
    }

    public FileFinder containingFile(final Predicate<File> fileInDir) {
        return this.withFileFilter(new Predicate<File>(){

            public boolean apply(File directory) {
                return FileFinder.this.directoryContainsFile(directory, (Predicate<File>)fileInDir);
            }
        });
    }

    public FileFinder contains(byte[] bytes) {
        throw new IllegalArgumentException();
    }

    private boolean directoryContainsFile(File directory, Predicate<File> containgFileFilter) {
        if (directory.isDirectory()) {
            File[] allFiles;
            for (File file : allFiles = directory.listFiles()) {
                if (!containgFileFilter.apply((Object)file)) continue;
                return true;
            }
        }
        return false;
    }
}

