/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.chunk;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.compress.ICompressor;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.write.page.ValuePageWriter;
import org.apache.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueChunkWriter {
    private static final Logger logger = LoggerFactory.getLogger(ValueChunkWriter.class);
    private final String measurementId;
    private final TSEncoding encodingType;
    private final TSDataType dataType;
    private final CompressionType compressionType;
    private final PublicBAOS pageBuffer;
    private int numOfPages;
    private ValuePageWriter pageWriter;
    private final long pageSizeThreshold;
    private final int maxNumberOfPointsInPage;
    private int valueCountInOnePageForNextCheck;
    private static final int MINIMUM_RECORD_COUNT_FOR_CHECK = 1500;
    private Statistics<? extends Serializable> statistics;
    private int sizeWithoutStatistic;
    private Statistics<?> firstPageStatistics;

    public ValueChunkWriter(String measurementId, CompressionType compressionType, TSDataType dataType, TSEncoding encodingType, Encoder valueEncoder) {
        this.measurementId = measurementId;
        this.encodingType = encodingType;
        this.dataType = dataType;
        this.compressionType = compressionType;
        this.pageBuffer = new PublicBAOS();
        this.pageSizeThreshold = TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        this.maxNumberOfPointsInPage = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        this.valueCountInOnePageForNextCheck = 1500;
        this.statistics = Statistics.getStatsByType(dataType);
        this.pageWriter = new ValuePageWriter(valueEncoder, ICompressor.getCompressor(compressionType), dataType);
    }

    public void write(long time, long value, boolean isNull) {
        this.pageWriter.write(time, value, isNull);
    }

    public void write(long time, int value, boolean isNull) {
        this.pageWriter.write(time, value, isNull);
    }

    public void write(long time, boolean value, boolean isNull) {
        this.pageWriter.write(time, value, isNull);
    }

    public void write(long time, float value, boolean isNull) {
        this.pageWriter.write(time, value, isNull);
    }

    public void write(long time, double value, boolean isNull) {
        this.pageWriter.write(time, value, isNull);
    }

    public void write(long time, Binary value, boolean isNull) {
        this.pageWriter.write(time, value, isNull);
    }

    public void write(long[] timestamps, int[] values, boolean[] isNull, int batchSize, int pos) {
        this.pageWriter.write(timestamps, values, isNull, batchSize, pos);
    }

    public void write(long[] timestamps, long[] values, boolean[] isNull, int batchSize, int pos) {
        this.pageWriter.write(timestamps, values, isNull, batchSize, pos);
    }

    public void write(long[] timestamps, boolean[] values, boolean[] isNull, int batchSize, int pos) {
        this.pageWriter.write(timestamps, values, isNull, batchSize, pos);
    }

    public void write(long[] timestamps, float[] values, boolean[] isNull, int batchSize, int pos) {
        this.pageWriter.write(timestamps, values, isNull, batchSize, pos);
    }

    public void write(long[] timestamps, double[] values, boolean[] isNull, int batchSize, int pos) {
        this.pageWriter.write(timestamps, values, isNull, batchSize, pos);
    }

    public void write(long[] timestamps, Binary[] values, boolean[] isNull, int batchSize, int pos) {
        this.pageWriter.write(timestamps, values, isNull, batchSize, pos);
    }

    public void writeEmptyPageToPageBuffer() throws IOException {
        if (this.numOfPages == 1 && this.firstPageStatistics != null) {
            byte[] b = this.pageBuffer.toByteArray();
            this.pageBuffer.reset();
            this.pageBuffer.write(b, 0, this.sizeWithoutStatistic);
            this.firstPageStatistics.serialize(this.pageBuffer);
            this.pageBuffer.write(b, this.sizeWithoutStatistic, b.length - this.sizeWithoutStatistic);
            this.firstPageStatistics = null;
        }
        this.pageWriter.writeEmptyPageIntoBuff(this.pageBuffer);
        ++this.numOfPages;
    }

    public void writePageToPageBuffer() {
        try {
            if (this.numOfPages == 0) {
                if (this.pageWriter.getStatistics().getCount() != 0L) {
                    this.firstPageStatistics = this.pageWriter.getStatistics();
                }
                this.sizeWithoutStatistic = this.pageWriter.writePageHeaderAndDataIntoBuff(this.pageBuffer, true);
            } else if (this.numOfPages == 1) {
                if (this.firstPageStatistics != null) {
                    byte[] b = this.pageBuffer.toByteArray();
                    this.pageBuffer.reset();
                    this.pageBuffer.write(b, 0, this.sizeWithoutStatistic);
                    this.firstPageStatistics.serialize(this.pageBuffer);
                    this.pageBuffer.write(b, this.sizeWithoutStatistic, b.length - this.sizeWithoutStatistic);
                }
                this.pageWriter.writePageHeaderAndDataIntoBuff(this.pageBuffer, false);
                this.firstPageStatistics = null;
            } else {
                this.pageWriter.writePageHeaderAndDataIntoBuff(this.pageBuffer, false);
            }
            ++this.numOfPages;
            this.statistics.mergeStatistics(this.pageWriter.getStatistics());
        }
        catch (IOException e) {
            logger.error("meet error in pageWriter.writePageHeaderAndDataIntoBuff,ignore this page:", (Throwable)e);
        }
        finally {
            this.pageWriter.reset(this.dataType);
        }
    }

    public void writePageHeaderAndDataIntoBuff(ByteBuffer data, PageHeader header) throws PageException {
        try {
            logger.debug("start to flush a page header into buffer, buffer position {} ", (Object)this.pageBuffer.size());
            if (this.numOfPages == 0) {
                this.sizeWithoutStatistic += ReadWriteForEncodingUtils.writeUnsignedVarInt(header.getUncompressedSize(), this.pageBuffer);
                if (header.getStatistics() == null) {
                    this.firstPageStatistics = null;
                } else {
                    this.firstPageStatistics = header.getStatistics();
                    this.sizeWithoutStatistic += ReadWriteForEncodingUtils.writeUnsignedVarInt(header.getCompressedSize(), this.pageBuffer);
                }
            } else if (this.numOfPages == 1) {
                if (this.firstPageStatistics != null) {
                    byte[] b = this.pageBuffer.toByteArray();
                    this.pageBuffer.reset();
                    this.pageBuffer.write(b, 0, this.sizeWithoutStatistic);
                    this.firstPageStatistics.serialize(this.pageBuffer);
                    this.pageBuffer.write(b, this.sizeWithoutStatistic, b.length - this.sizeWithoutStatistic);
                }
                ReadWriteForEncodingUtils.writeUnsignedVarInt(header.getUncompressedSize(), this.pageBuffer);
                if (header.getUncompressedSize() != 0) {
                    ReadWriteForEncodingUtils.writeUnsignedVarInt(header.getCompressedSize(), this.pageBuffer);
                    header.getStatistics().serialize(this.pageBuffer);
                }
                this.firstPageStatistics = null;
            } else {
                ReadWriteForEncodingUtils.writeUnsignedVarInt(header.getUncompressedSize(), this.pageBuffer);
                if (header.getUncompressedSize() != 0) {
                    ReadWriteForEncodingUtils.writeUnsignedVarInt(header.getCompressedSize(), this.pageBuffer);
                    header.getStatistics().serialize(this.pageBuffer);
                }
            }
            logger.debug("finish to flush a page header {} of time page into buffer, buffer position {} ", (Object)header, (Object)this.pageBuffer.size());
            if (header.getStatistics() != null) {
                this.statistics.mergeStatistics(header.getStatistics());
            }
        }
        catch (IOException e) {
            throw new PageException("IO Exception in writeDataPageHeader,ignore this page", e);
        }
        ++this.numOfPages;
        try (WritableByteChannel channel = Channels.newChannel(this.pageBuffer);){
            channel.write(data);
        }
        catch (IOException e) {
            throw new PageException(e);
        }
    }

    public void writeToFileWriter(TsFileIOWriter tsfileWriter) throws IOException {
        this.sealCurrentPage();
        this.writeAllPagesOfChunkToTsFile(tsfileWriter);
        this.pageBuffer.reset();
        this.numOfPages = 0;
        this.sizeWithoutStatistic = 0;
        this.firstPageStatistics = null;
        this.statistics = Statistics.getStatsByType(this.dataType);
    }

    public long estimateMaxSeriesMemSize() {
        return (long)this.pageBuffer.size() + this.pageWriter.estimateMaxMemSize() + (long)PageHeader.estimateMaxPageHeaderSizeWithoutStatistics() + (long)this.pageWriter.getStatistics().getSerializedSize();
    }

    public long getCurrentChunkSize() {
        if (this.pageBuffer.size() == 0) {
            return 0L;
        }
        if (this.statistics.getCount() == 0L) {
            return ChunkHeader.getSerializedSize(this.measurementId, 0);
        }
        return (long)ChunkHeader.getSerializedSize(this.measurementId, this.pageBuffer.size()) + (long)this.pageBuffer.size();
    }

    public boolean checkPageSizeAndMayOpenANewPage() {
        if (this.pageWriter.getPointNumber() == (long)this.maxNumberOfPointsInPage) {
            logger.debug("current line count reaches the upper bound, write page {}", (Object)this.measurementId);
            return true;
        }
        if (this.pageWriter.getPointNumber() >= (long)this.valueCountInOnePageForNextCheck) {
            long currentPageSize = this.pageWriter.estimateMaxMemSize();
            if (currentPageSize > this.pageSizeThreshold) {
                logger.debug("enough size, write page {}, pageSizeThreshold:{}, currentPageSize:{}, valueCountInOnePage:{}", new Object[]{this.measurementId, this.pageSizeThreshold, currentPageSize, this.pageWriter.getPointNumber()});
                this.valueCountInOnePageForNextCheck = 1500;
                return true;
            }
            this.valueCountInOnePageForNextCheck = (int)((float)this.pageSizeThreshold / (float)currentPageSize * (float)this.pageWriter.getPointNumber());
        }
        return false;
    }

    public void sealCurrentPage() {
        if (this.pageWriter != null && this.pageWriter.getSize() != 0) {
            this.writePageToPageBuffer();
        }
    }

    public void clearPageWriter() {
        this.pageWriter = null;
    }

    public int getNumOfPages() {
        return this.numOfPages;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public void writeAllPagesOfChunkToTsFile(TsFileIOWriter writer) throws IOException {
        if (this.statistics.getCount() == 0L) {
            if (this.pageBuffer.size() == 0) {
                return;
            }
            writer.startFlushChunk(this.measurementId, this.compressionType, this.dataType, this.encodingType, this.statistics, 0, 0, 64);
            writer.endCurrentChunk();
            return;
        }
        writer.startFlushChunk(this.measurementId, this.compressionType, this.dataType, this.encodingType, this.statistics, this.pageBuffer.size(), this.numOfPages, 64);
        long dataOffset = writer.getPos();
        writer.writeBytesToStream(this.pageBuffer);
        int dataSize = (int)(writer.getPos() - dataOffset);
        if (dataSize != this.pageBuffer.size()) {
            throw new IOException("Bytes written is inconsistent with the size of data: " + dataSize + " != " + this.pageBuffer.size());
        }
        writer.endCurrentChunk();
    }

    public String getMeasurementId() {
        return this.measurementId;
    }

    public TSEncoding getEncodingType() {
        return this.encodingType;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public PublicBAOS getPageBuffer() {
        return this.pageBuffer;
    }

    public boolean checkIsUnsealedPageOverThreshold(long size) {
        return this.pageWriter.estimateMaxMemSize() >= size;
    }

    public ValuePageWriter getPageWriter() {
        return this.pageWriter;
    }
}

