/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.converter;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.exception.load.LoadRuntimeOutOfMemoryException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.rpc.TSStatusCode;

public class LoadConvertedInsertTabletStatementExceptionVisitor
extends StatementVisitor<TSStatus, Exception> {
    @Override
    public TSStatus visitNode(StatementNode node, Exception context) {
        return new TSStatus(TSStatusCode.LOAD_FILE_ERROR.getStatusCode()).setMessage(context.getMessage());
    }

    @Override
    public TSStatus visitLoadFile(LoadTsFileStatement loadTsFileStatement, Exception context) {
        if (context instanceof LoadRuntimeOutOfMemoryException) {
            return new TSStatus(TSStatusCode.LOAD_TEMPORARY_UNAVAILABLE_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context instanceof SemanticException) {
            return new TSStatus(TSStatusCode.LOAD_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)this.visitStatement(loadTsFileStatement, context);
    }
}

