/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.metric;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingQueue;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPrefetchingQueueMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPrefetchingQueueMetrics.class);
    private volatile AbstractMetricService metricService;
    private final Map<String, SubscriptionPrefetchingQueue> prefetchingQueueMap = new ConcurrentHashMap<String, SubscriptionPrefetchingQueue>();
    private final Map<String, Rate> rateMap = new ConcurrentHashMap<String, Rate>();

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ImmutableSet ids = ImmutableSet.copyOf(this.prefetchingQueueMap.keySet());
        for (String id : ids) {
            this.createMetrics(id);
        }
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet ids = ImmutableSet.copyOf(this.prefetchingQueueMap.keySet());
        for (String id : ids) {
            this.deregister(id);
        }
        if (!this.prefetchingQueueMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from subscription prefetching queue metrics, prefetching queue map not empty");
        }
    }

    public void register(@NonNull SubscriptionPrefetchingQueue prefetchingQueue) {
        String id = prefetchingQueue.getPrefetchingQueueId();
        this.prefetchingQueueMap.putIfAbsent(id, prefetchingQueue);
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(id);
        }
    }

    private void createMetrics(String id) {
        this.createAutoGauge(id);
        this.createRate(id);
    }

    private void createAutoGauge(String id) {
        SubscriptionPrefetchingQueue queue = this.prefetchingQueueMap.get(id);
        this.metricService.createAutoGauge(Metric.SUBSCRIPTION_UNCOMMITTED_EVENT_COUNT.toString(), MetricLevel.IMPORTANT, (Object)queue, SubscriptionPrefetchingQueue::getSubscriptionUncommittedEventCount, new String[]{Tag.NAME.toString(), queue.getPrefetchingQueueId()});
        this.metricService.createAutoGauge(Metric.SUBSCRIPTION_CURRENT_COMMIT_ID.toString(), MetricLevel.IMPORTANT, (Object)queue, SubscriptionPrefetchingQueue::getCurrentCommitId, new String[]{Tag.NAME.toString(), queue.getPrefetchingQueueId()});
    }

    private void createRate(String id) {
        SubscriptionPrefetchingQueue queue = this.prefetchingQueueMap.get(id);
        this.rateMap.put(id, this.metricService.getOrCreateRate(Metric.SUBSCRIPTION_EVENT_TRANSFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), queue.getPrefetchingQueueId()}));
    }

    public void deregister(String id) {
        if (!this.prefetchingQueueMap.containsKey(id)) {
            LOGGER.warn("Failed to deregister subscription prefetching queue metrics, SubscriptionPrefetchingQueue({}) does not exist", (Object)id);
            return;
        }
        if (Objects.nonNull(this.metricService)) {
            this.removeMetrics(id);
        }
        this.prefetchingQueueMap.remove(id);
    }

    private void removeMetrics(String id) {
        this.removeAutoGauge(id);
        this.removeRate(id);
    }

    private void removeAutoGauge(String id) {
        SubscriptionPrefetchingQueue queue = this.prefetchingQueueMap.get(id);
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.SUBSCRIPTION_UNCOMMITTED_EVENT_COUNT.toString(), new String[]{Tag.NAME.toString(), queue.getPrefetchingQueueId()});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.SUBSCRIPTION_CURRENT_COMMIT_ID.toString(), new String[]{Tag.NAME.toString(), queue.getPrefetchingQueueId()});
    }

    private void removeRate(String id) {
        SubscriptionPrefetchingQueue queue = this.prefetchingQueueMap.get(id);
        this.metricService.remove(MetricType.RATE, Metric.SUBSCRIPTION_EVENT_TRANSFER.toString(), new String[]{Tag.NAME.toString(), queue.getPrefetchingQueueId()});
    }

    public void mark(String id, long size) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        Rate rate = this.rateMap.get(id);
        if (rate == null) {
            LOGGER.warn("Failed to mark transfer event rate, SubscriptionPrefetchingQueue({}) does not exist", (Object)id);
            return;
        }
        rate.mark(size);
    }

    public static SubscriptionPrefetchingQueueMetrics getInstance() {
        return SubscriptionPrefetchingQueueMetricsHolder.INSTANCE;
    }

    private SubscriptionPrefetchingQueueMetrics() {
    }

    private static class SubscriptionPrefetchingQueueMetricsHolder {
        private static final SubscriptionPrefetchingQueueMetrics INSTANCE = new SubscriptionPrefetchingQueueMetrics();

        private SubscriptionPrefetchingQueueMetricsHolder() {
        }
    }
}

