/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.table.column;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.schema.table.column.AttributeColumnSchema;
import org.apache.iotdb.commons.schema.table.column.FieldColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TagColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TimeColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TsTableColumnSchemaUtil {
    private TsTableColumnSchemaUtil() {
    }

    public static void serialize(TsTableColumnSchema columnSchema, OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)columnSchema.getColumnCategory().getValue(), (OutputStream)outputStream);
        columnSchema.serialize(outputStream);
    }

    public static TsTableColumnSchema deserialize(InputStream inputStream) throws IOException {
        return TsTableColumnSchemaUtil.deserialize(TsTableColumnCategory.deserialize(inputStream), inputStream);
    }

    private static TsTableColumnSchema deserialize(TsTableColumnCategory category, InputStream stream) throws IOException {
        switch (category) {
            case TAG: {
                return TagColumnSchema.deserialize(stream);
            }
            case ATTRIBUTE: {
                return AttributeColumnSchema.deserialize(stream);
            }
            case TIME: {
                return TimeColumnSchema.deserialize(stream);
            }
            case FIELD: {
                return FieldColumnSchema.deserialize(stream);
            }
        }
        throw new IllegalArgumentException();
    }

    public static TsTableColumnSchema deserialize(ByteBuffer buffer) {
        return TsTableColumnSchemaUtil.deserialize(TsTableColumnCategory.deserialize(buffer), buffer);
    }

    private static TsTableColumnSchema deserialize(TsTableColumnCategory category, ByteBuffer buffer) {
        switch (category) {
            case TAG: {
                return TagColumnSchema.deserialize(buffer);
            }
            case ATTRIBUTE: {
                return AttributeColumnSchema.deserialize(buffer);
            }
            case TIME: {
                return TimeColumnSchema.deserialize(buffer);
            }
            case FIELD: {
                return FieldColumnSchema.deserialize(buffer);
            }
        }
        throw new IllegalArgumentException();
    }

    public static byte[] serialize(List<TsTableColumnSchema> columnSchemaList) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            TsTableColumnSchemaUtil.serialize(columnSchemaList, (OutputStream)stream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stream.toByteArray();
    }

    public static void serialize(List<TsTableColumnSchema> columnSchemaList, OutputStream stream) throws IOException {
        if (columnSchemaList == null) {
            ReadWriteIOUtils.write((int)-1, (OutputStream)stream);
            return;
        }
        ReadWriteIOUtils.write((int)columnSchemaList.size(), (OutputStream)stream);
        for (TsTableColumnSchema columnSchema : columnSchemaList) {
            TsTableColumnSchemaUtil.serialize(columnSchema, stream);
        }
    }

    public static List<TsTableColumnSchema> deserializeColumnSchemaList(ByteBuffer buffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        if (size == -1) {
            throw new IllegalArgumentException("size should not be -1");
        }
        ArrayList<TsTableColumnSchema> columnSchemaList = new ArrayList<TsTableColumnSchema>(size);
        for (int i = 0; i < size; ++i) {
            columnSchemaList.add(TsTableColumnSchemaUtil.deserialize(buffer));
        }
        return columnSchemaList;
    }
}

