/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.table;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.table.AbstractTablePlan;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class RenameTablePlan
extends AbstractTablePlan {
    private String newName;

    public RenameTablePlan(ConfigPhysicalPlanType type) {
        super(type);
    }

    public RenameTablePlan(String database, String tableName, String newName) {
        this(ConfigPhysicalPlanType.RenameTable, database, tableName, newName);
    }

    protected RenameTablePlan(ConfigPhysicalPlanType type, String database, String tableName, String newName) {
        super(type, database, tableName);
        this.newName = newName;
    }

    public String getNewName() {
        return this.newName;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        super.serializeImpl(stream);
        ReadWriteIOUtils.write((String)this.newName, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        super.deserializeImpl(buffer);
        this.newName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
    }
}

