/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.metric.overview;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.confignode.procedure.impl.pipe.PipeTaskOperation;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeProcedureMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeProcedureMetrics.class);
    private final Map<String, Timer> timerMap = new HashMap<String, Timer>();

    public void bindTo(AbstractMetricService metricService) {
        Arrays.stream(PipeTaskOperation.values()).forEach(op -> this.timerMap.put(op.getName(), metricService.getOrCreateTimer(Metric.PIPE_PROCEDURE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), op.getName()})));
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.timerMap.forEach((name, timer) -> metricService.remove(MetricType.TIMER, Metric.PIPE_PROCEDURE.toString(), new String[]{Tag.NAME.toString(), name}));
    }

    public void updateTimer(String name, long durationMillis) {
        Timer timer = this.timerMap.get(name);
        if (timer == null) {
            LOGGER.warn("Failed to update pipe procedure timer, PipeProcedure({}) does not exist", (Object)name);
            return;
        }
        timer.updateMillis(durationMillis);
    }

    public static PipeProcedureMetrics getInstance() {
        return PipeProcedureMetricsHolder.INSTANCE;
    }

    private PipeProcedureMetrics() {
    }

    private static class PipeProcedureMetricsHolder {
        private static final PipeProcedureMetrics INSTANCE = new PipeProcedureMetrics();

        private PipeProcedureMetricsHolder() {
        }
    }
}

