/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.consensus.metric;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.receiver.protocol.pipeconsensus.PipeConsensusReceiver;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class PipeConsensusReceiverMetrics
implements IMetricSet {
    private final PipeConsensusReceiver pipeConsensusReceiver;
    private Timer tsFilePieceWriteTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer tsFilePiecePreCheckTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer tsFileSealLoadTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer tsFileSealPreCheckTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer borrowTsFileWriterTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer acquireExecutorLockTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer dispatchWaitingTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer receiveWALTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer receiveTsFileTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer receiveEventTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String RECEIVER = "pipeConsensusReceiver";

    public PipeConsensusReceiverMetrics(PipeConsensusReceiver pipeConsensusReceiver) {
        this.pipeConsensusReceiver = pipeConsensusReceiver;
    }

    public void recordTsFilePieceWriteTime(long costTimeInNanos) {
        this.tsFilePieceWriteTimer.updateNanos(costTimeInNanos);
    }

    public void recordTsFilePiecePreCheckTime(long costTimeInNanos) {
        this.tsFilePiecePreCheckTimer.updateNanos(costTimeInNanos);
    }

    public void recordTsFileSealLoadTimer(long costTimeInNanos) {
        this.tsFileSealLoadTimer.updateNanos(costTimeInNanos);
    }

    public void recordTsFileSealPreCheckTimer(long costTimeInNanos) {
        this.tsFileSealPreCheckTimer.updateNanos(costTimeInNanos);
    }

    public void recordBorrowTsFileWriterTimer(long costTimeInNanos) {
        this.borrowTsFileWriterTimer.updateNanos(costTimeInNanos);
    }

    public void recordAcquireExecutorLockTimer(long costTimeInNanos) {
        this.acquireExecutorLockTimer.updateNanos(costTimeInNanos);
    }

    public void recordDispatchWaitingTimer(long costTimeInNanos) {
        this.dispatchWaitingTimer.updateNanos(costTimeInNanos);
    }

    public void recordReceiveWALTimer(long costTimeInNanos) {
        this.receiveWALTimer.updateNanos(costTimeInNanos);
    }

    public void recordReceiveTsFileTimer(long costTimeInNanos) {
        this.receiveTsFileTimer.updateNanos(costTimeInNanos);
    }

    public void recordReceiveEventTimer(long costTimeInNanos) {
        this.receiveEventTimer.updateNanos(costTimeInNanos);
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindAutoGauge(metricService);
        this.bindStageTimer(metricService);
        this.bindReceiveTimer(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindAutoGauge(metricService);
        this.unbindStageTimer(metricService);
        this.unbindReceiveTimer(metricService);
    }

    public void bindAutoGauge(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.PIPE_RECEIVE_EVENT.toString(), MetricLevel.IMPORTANT, (Object)this.pipeConsensusReceiver, PipeConsensusReceiver::getReceiveBufferSize, new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "receiveBufferSize"});
        metricService.createAutoGauge(Metric.PIPE_RECEIVE_EVENT.toString(), MetricLevel.IMPORTANT, (Object)this.pipeConsensusReceiver, PipeConsensusReceiver::getWALEventCount, new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "WALEventCount"});
        metricService.createAutoGauge(Metric.PIPE_RECEIVE_EVENT.toString(), MetricLevel.IMPORTANT, (Object)this.pipeConsensusReceiver, PipeConsensusReceiver::getTsFileEventCount, new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "tsFileEventCount"});
    }

    public void bindStageTimer(AbstractMetricService metricService) {
        this.tsFilePieceWriteTimer = metricService.getOrCreateTimer(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "tsFilePieceWrite"});
        this.tsFilePiecePreCheckTimer = metricService.getOrCreateTimer(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "tsFilePiecePreCheck"});
        this.tsFileSealLoadTimer = metricService.getOrCreateTimer(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "tsFileSealLoad"});
        this.tsFileSealPreCheckTimer = metricService.getOrCreateTimer(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "tsFileSealPreCheck"});
        this.borrowTsFileWriterTimer = metricService.getOrCreateTimer(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "borrowTsFileWriter"});
        this.acquireExecutorLockTimer = metricService.getOrCreateTimer(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "acquireExecutorLock"});
        this.dispatchWaitingTimer = metricService.getOrCreateTimer(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "dispatchWaiting"});
    }

    public void bindReceiveTimer(AbstractMetricService metricService) {
        this.receiveEventTimer = metricService.getOrCreateTimer(Metric.PIPE_RECEIVE_EVENT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "receiveEvent"});
        this.receiveWALTimer = metricService.getOrCreateTimer(Metric.PIPE_RECEIVE_EVENT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "receiveWALEvent"});
        this.receiveTsFileTimer = metricService.getOrCreateTimer(Metric.PIPE_RECEIVE_EVENT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "receiveTsFileEvent"});
    }

    public void unbindAutoGauge(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_RECEIVE_EVENT.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "receiveBufferSize"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_RECEIVE_EVENT.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "WALEventCount"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_RECEIVE_EVENT.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "tsFileEventCount"});
    }

    public void unbindStageTimer(AbstractMetricService metricService) {
        this.tsFilePieceWriteTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.tsFilePiecePreCheckTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.tsFileSealLoadTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.tsFileSealPreCheckTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.borrowTsFileWriterTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.acquireExecutorLockTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.dispatchWaitingTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        metricService.remove(MetricType.TIMER, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "tsFilePieceWrite"});
        metricService.remove(MetricType.TIMER, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "tsFilePiecePreCheck"});
        metricService.remove(MetricType.TIMER, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "tsFileSealLoad"});
        metricService.remove(MetricType.TIMER, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "tsFileSealPreCheck"});
        metricService.remove(MetricType.TIMER, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "borrowTsFileWriter"});
        metricService.remove(MetricType.TIMER, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "acquireExecutorLock"});
        metricService.remove(MetricType.TIMER, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "dispatchWaiting"});
    }

    public void unbindReceiveTimer(AbstractMetricService metricService) {
        this.receiveWALTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.receiveTsFileTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.receiveEventTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        metricService.remove(MetricType.TIMER, Metric.PIPE_RECEIVE_EVENT.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "receiveWALEvent"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_RECEIVE_EVENT.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "receiveTsFileEvent"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_RECEIVE_EVENT.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.REGION.toString(), this.pipeConsensusReceiver.getConsensusGroupIdStr(), Tag.TYPE.toString(), "receiveEvent"});
    }
}

