/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.aggregation.TreeAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AbstractConsumeAllOperator;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TagAggregationOperator
extends AbstractConsumeAllOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TagAggregationOperator.class);
    private final List<List<String>> groups;
    private final List<List<TreeAggregator>> groupedAggregators;
    private final int[] consumedIndices;
    private final TsBlockBuilder tsBlockBuilder;
    private final long maxRetainedSize;
    private final long childrenRetainedSize;

    public TagAggregationOperator(OperatorContext operatorContext, List<List<String>> groups, List<List<TreeAggregator>> groupedAggregators, List<Operator> children, long maxReturnSize) {
        super(operatorContext, children);
        this.groups = (List)Validate.notNull(groups);
        this.groupedAggregators = (List)Validate.notNull(groupedAggregators);
        ArrayList<TSDataType> actualOutputColumnTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < groups.get(0).size(); ++i) {
            actualOutputColumnTypes.add(TSDataType.TEXT);
        }
        block1: for (int outputColumnIdx = 0; outputColumnIdx < groupedAggregators.get(0).size(); ++outputColumnIdx) {
            for (List<TreeAggregator> aggregators : groupedAggregators) {
                TreeAggregator aggregator = aggregators.get(outputColumnIdx);
                if (aggregator == null) continue;
                actualOutputColumnTypes.addAll(Arrays.asList(aggregator.getOutputType()));
                continue block1;
            }
        }
        this.tsBlockBuilder = new TsBlockBuilder(actualOutputColumnTypes);
        Arrays.fill(this.canCallNext, false);
        this.consumedIndices = new int[children.size()];
        this.maxRetainedSize = children.stream().mapToLong(Operator::calculateMaxReturnSize).sum();
        this.childrenRetainedSize = children.stream().mapToLong(Operator::calculateRetainedSizeAfterCallingNext).sum();
        this.maxReturnSize = maxReturnSize;
    }

    @Override
    public TsBlock next() throws Exception {
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        while (System.nanoTime() - start < maxRuntime && !this.tsBlockBuilder.isFull() && this.prepareInput()) {
            this.processOneRow();
        }
        TsBlock tsBlock = null;
        if (this.tsBlockBuilder.getPositionCount() > 0) {
            tsBlock = this.tsBlockBuilder.build();
        }
        this.tsBlockBuilder.reset();
        return tsBlock;
    }

    private void processOneRow() {
        int i;
        TsBlock[] rowBlocks = new TsBlock[this.children.size()];
        for (i = 0; i < this.children.size(); ++i) {
            rowBlocks[i] = this.inputTsBlocks[i].getRegion(this.consumedIndices[i], 1);
        }
        for (int groupIdx = 0; groupIdx < this.groups.size(); ++groupIdx) {
            List<TreeAggregator> aggregators = this.groupedAggregators.get(groupIdx);
            this.aggregate(aggregators, rowBlocks);
            List<String> group = this.groups.get(groupIdx);
            this.appendOneRow(rowBlocks, group, aggregators);
        }
        i = 0;
        while (i < this.children.size()) {
            int n = i++;
            this.consumedIndices[n] = this.consumedIndices[n] + 1;
        }
    }

    private void aggregate(List<TreeAggregator> aggregators, TsBlock[] rowBlocks) {
        for (TreeAggregator aggregator : aggregators) {
            if (aggregator == null) continue;
            aggregator.reset();
            aggregator.processTsBlocks(rowBlocks);
        }
    }

    private void appendOneRow(TsBlock[] rowBlocks, List<String> group, List<TreeAggregator> aggregators) {
        int i;
        TimeColumnBuilder timeColumnBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        timeColumnBuilder.writeLong(rowBlocks[0].getStartTime());
        ColumnBuilder[] columnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
        for (i = 0; i < group.size(); ++i) {
            if (group.get(i) == null) {
                columnBuilders[i].writeBinary(new Binary("NULL", TSFileConfig.STRING_CHARSET));
                continue;
            }
            columnBuilders[i].writeBinary(new Binary(group.get(i), TSFileConfig.STRING_CHARSET));
        }
        for (i = 0; i < aggregators.size(); ++i) {
            TreeAggregator aggregator = aggregators.get(i);
            ColumnBuilder columnBuilder = columnBuilders[i + group.size()];
            if (aggregator == null) {
                columnBuilder.appendNull();
                continue;
            }
            aggregator.outputResult(new ColumnBuilder[]{columnBuilder});
        }
        this.tsBlockBuilder.declarePosition();
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.isEmpty(this.readyChildIndex) || ((Operator)this.children.get(this.readyChildIndex)).hasNextWithTimer();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.maxReturnSize + this.maxRetainedSize + this.childrenRetainedSize;
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.maxRetainedSize + this.childrenRetainedSize;
    }

    @Override
    protected boolean isEmpty(int index) {
        return this.inputTsBlocks[index] == null || this.consumedIndices[index] == this.inputTsBlocks[index].getPositionCount();
    }

    @Override
    protected TsBlock getNextTsBlock(int childIndex) throws Exception {
        this.consumedIndices[childIndex] = 0;
        return ((Operator)this.children.get(childIndex)).nextWithTimer();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.children.stream().mapToLong(MemoryEstimationHelper::getEstimatedSizeOfAccountableObject).sum() + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + RamUsageEstimator.sizeOf((boolean[])this.canCallNext) + RamUsageEstimator.sizeOf((int[])this.consumedIndices) + this.groups.stream().mapToLong(group -> group.stream().mapToLong(RamUsageEstimator::sizeOf).sum()).sum() + this.tsBlockBuilder.getRetainedSizeInBytes();
    }
}

