/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.linear;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.linear.LinearFill;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.column.LongColumn;
import org.apache.tsfile.read.common.block.column.LongColumnBuilder;

public class LongLinearFill
extends LinearFill {
    private long previousValue;
    private long nextValue;
    private long nextValueInCurrentColumn;

    @Override
    void fillValue(Column column, int index, Object array) {
        ((long[])array)[index] = column.getLong(index);
    }

    @Override
    void fillValue(Object array, int index, double factor) {
        ((long[])array)[index] = this.getFilledValue(factor);
    }

    @Override
    Object createValueArray(int size) {
        return new long[size];
    }

    @Override
    Column createNullValueColumn() {
        return LongColumnBuilder.NULL_VALUE_BLOCK;
    }

    @Override
    Column createFilledValueColumn(double[] factors, Optional<boolean[]> valueIsNull) {
        int size = factors.length;
        long[] filledValue = new long[size];
        if (valueIsNull.isPresent()) {
            boolean[] isNull = valueIsNull.get();
            for (int i = 0; i < size; ++i) {
                if (isNull[i]) continue;
                filledValue[i] = this.getFilledValue(factors[i]);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                filledValue[i] = this.getFilledValue(factors[i]);
            }
        }
        return new LongColumn(size, valueIsNull, filledValue);
    }

    @Override
    Column createFilledValueColumn(Object array, boolean[] isNull, boolean hasNullValue, int size) {
        if (hasNullValue) {
            return new LongColumn(size, Optional.of(isNull), (long[])array);
        }
        return new LongColumn(size, Optional.empty(), (long[])array);
    }

    @Override
    void updatePreviousValue(Column column, int index) {
        this.previousValue = column.getLong(index);
    }

    @Override
    void updateNextValue(Column nextValueColumn, int index) {
        this.nextValue = nextValueColumn.getLong(index);
    }

    @Override
    void updateNextValueInCurrentColumn(Column nextValueColumn, int index) {
        this.nextValueInCurrentColumn = nextValueColumn.getLong(index);
    }

    @Override
    void updateNextValueInCurrentColumn() {
        this.nextValueInCurrentColumn = this.nextValue;
    }

    private long getFilledValue(double factor) {
        return (long)((double)this.previousValue + (double)(this.nextValueInCurrentColumn - this.previousValue) * factor);
    }
}

