/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.IntoPathDescriptor;

public class IntoNode
extends SingleChildProcessNode {
    private final IntoPathDescriptor intoPathDescriptor;

    public IntoNode(PlanNodeId id, IntoPathDescriptor intoPathDescriptor) {
        super(id);
        this.intoPathDescriptor = intoPathDescriptor;
    }

    public IntoNode(PlanNodeId id, PlanNode child, IntoPathDescriptor intoPathDescriptor) {
        super(id, child);
        this.intoPathDescriptor = intoPathDescriptor;
    }

    public IntoPathDescriptor getIntoPathDescriptor() {
        return this.intoPathDescriptor;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.INTO;
    }

    @Override
    public PlanNode clone() {
        return new IntoNode(this.getPlanNodeId(), this.intoPathDescriptor);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return ColumnHeaderConstant.selectIntoColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.INTO.serialize(byteBuffer);
        this.intoPathDescriptor.serialize(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.INTO.serialize(stream);
        this.intoPathDescriptor.serialize(stream);
    }

    public static IntoNode deserialize(ByteBuffer byteBuffer) {
        IntoPathDescriptor intoPathDescriptor = IntoPathDescriptor.deserialize(byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new IntoNode(planNodeId, intoPathDescriptor);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitInto(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntoNode intoNode = (IntoNode)o;
        return this.intoPathDescriptor.equals(intoNode.intoPathDescriptor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.intoPathDescriptor);
    }

    public String toString() {
        return "IntoNode-" + this.getPlanNodeId();
    }
}

