/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.distribute;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.SubPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.MultiChildrenSinkNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ExchangeNode;

public class SubPlanGenerator {
    public SubPlan splitToSubPlan(QueryId queryId, PlanNode rootPlanNode) {
        SubPlan rootSubPlan = this.createSubPlan(rootPlanNode, queryId);
        HashSet<PlanNodeId> visitedSinkNode = new HashSet<PlanNodeId>();
        this.splitToSubPlan(rootPlanNode, rootSubPlan, visitedSinkNode, queryId);
        return rootSubPlan;
    }

    private void splitToSubPlan(PlanNode root, SubPlan subPlan, Set<PlanNodeId> visitedSinkNode, QueryId queryId) {
        if (root instanceof WritePlanNode) {
            return;
        }
        if (root instanceof ExchangeNode) {
            ExchangeNode exchangeNode = (ExchangeNode)root;
            Validate.isTrue((boolean)(exchangeNode.getChild() instanceof MultiChildrenSinkNode), (String)"child of ExchangeNode must be MultiChildrenSinkNode", (Object[])new Object[0]);
            MultiChildrenSinkNode sinkNode = (MultiChildrenSinkNode)exchangeNode.getChild();
            exchangeNode.cleanChildren();
            if (!visitedSinkNode.contains(sinkNode.getPlanNodeId())) {
                visitedSinkNode.add(sinkNode.getPlanNodeId());
                SubPlan childSubPlan = this.createSubPlan(sinkNode, queryId);
                this.splitToSubPlan(sinkNode, childSubPlan, visitedSinkNode, queryId);
                subPlan.addChild(childSubPlan);
            }
            return;
        }
        for (PlanNode child : root.getChildren()) {
            this.splitToSubPlan(child, subPlan, visitedSinkNode, queryId);
        }
    }

    private SubPlan createSubPlan(PlanNode root, QueryId queryId) {
        PlanFragment fragment = new PlanFragment(queryId.genPlanFragmentId(), root);
        return new SubPlan(fragment);
    }
}

