/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.utils.matching;

import java.util.Collections;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.PatternVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.pattern.CapturePattern;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.pattern.EqualsPattern;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.pattern.FilterPattern;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.pattern.TypeOfPattern;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.pattern.WithPattern;

public class DefaultPrinter
implements PatternVisitor {
    private final StringBuilder result = new StringBuilder();
    private int level;

    public String result() {
        return this.result.toString();
    }

    @Override
    public void visitTypeOf(TypeOfPattern<?> pattern) {
        this.visitPrevious(pattern);
        this.appendLine("typeOf(%s)", pattern.expectedClass().getSimpleName());
    }

    @Override
    public void visitWith(WithPattern<?> pattern) {
        this.visitPrevious(pattern);
        this.appendLine("with(%s)", pattern.getProperty().getName());
        ++this.level;
        pattern.getPattern().accept(this);
        --this.level;
    }

    @Override
    public void visitCapture(CapturePattern<?> pattern) {
        this.visitPrevious(pattern);
        this.appendLine("capturedAs(%s)", pattern.capture().description());
    }

    @Override
    public void visitEquals(EqualsPattern<?> pattern) {
        this.visitPrevious(pattern);
        this.appendLine("equals(%s)", pattern.expectedValue());
    }

    @Override
    public void visitFilter(FilterPattern<?> pattern) {
        this.visitPrevious(pattern);
        this.appendLine("filter(%s)", pattern.predicate());
    }

    private void appendLine(String template, Object ... arguments) {
        this.result.append(String.join((CharSequence)"", Collections.nCopies(this.level, "\t"))).append(String.format(template + "\n", arguments));
    }
}

